/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.canonicalize;

import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.archive.modules.canonicalize.BaseRule;

public class RegexRule
extends BaseRule {
    private static final long serialVersionUID = -3L;
    protected static Logger logger = Logger.getLogger(BaseRule.class.getName());

    public Pattern getRegex() {
        return (Pattern)this.kp.get("regex");
    }

    public void setRegex(Pattern regex) {
        this.kp.put((Object)"regex", (Object)regex);
    }

    public String getFormat() {
        return (String)this.kp.get("format");
    }

    public void setFormat(String format) {
        this.kp.put((Object)"format", (Object)format);
    }

    public RegexRule() {
        this.setRegex(Pattern.compile("(.*)"));
        this.setFormat("$1");
    }

    @Override
    public String canonicalize(String url) {
        Pattern pattern = this.getRegex();
        Matcher matcher = pattern.matcher(url);
        if (!matcher.matches()) {
            return url;
        }
        StringBuffer buffer = new StringBuffer(url.length() * 2);
        matcher.appendReplacement(buffer, this.getFormat());
        return buffer.toString();
    }
}

