/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.canonicalize;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.modules.canonicalize.CanonicalizationRule;
import org.archive.modules.canonicalize.FixupQueryString;
import org.archive.modules.canonicalize.LowercaseRule;
import org.archive.modules.canonicalize.StripSessionCFIDs;
import org.archive.modules.canonicalize.StripSessionIDs;
import org.archive.modules.canonicalize.StripUserinfoRule;
import org.archive.modules.canonicalize.StripWWWNRule;
import org.archive.modules.canonicalize.UriCanonicalizationPolicy;
import org.archive.spring.HasKeyedProperties;
import org.archive.spring.KeyedProperties;

public class RulesCanonicalizationPolicy
extends UriCanonicalizationPolicy
implements HasKeyedProperties {
    private static Logger logger = Logger.getLogger(RulesCanonicalizationPolicy.class.getName());
    protected KeyedProperties kp = new KeyedProperties();

    public RulesCanonicalizationPolicy() {
        this.setRules(RulesCanonicalizationPolicy.getDefaultRules());
    }

    public KeyedProperties getKeyedProperties() {
        return this.kp;
    }

    public List<CanonicalizationRule> getRules() {
        return (List)this.kp.get("rules");
    }

    public void setRules(List<CanonicalizationRule> rules) {
        this.kp.put((Object)"rules", rules);
    }

    @Override
    public String canonicalize(String before) {
        String canonical = before;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Canonicalizing: " + before);
        }
        for (CanonicalizationRule rule : this.getRules()) {
            if (rule.getEnabled()) {
                canonical = rule.canonicalize(canonical);
            }
            if (!logger.isLoggable(Level.FINER)) continue;
            logger.finer("Rule " + rule.getClass().getName() + " " + (rule.getEnabled() ? canonical : " (disabled)"));
        }
        return canonical;
    }

    public static List<CanonicalizationRule> getDefaultRules() {
        ArrayList<CanonicalizationRule> rules = new ArrayList<CanonicalizationRule>(6);
        rules.add(new LowercaseRule());
        rules.add(new StripUserinfoRule());
        rules.add(new StripWWWNRule());
        rules.add(new StripSessionIDs());
        rules.add(new StripSessionCFIDs());
        rules.add(new FixupQueryString());
        return rules;
    }
}

