/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.canonicalize;

import org.archive.modules.canonicalize.BaseRule;

public class StripSessionIDs
extends BaseRule {
    private static final long serialVersionUID = 3L;
    private static final String BASE_PATTERN = "(?i)^(.+)(?:(?:(?:jsessionid)|(?:phpsessid))=[0-9a-zA-Z]{32})(?:&(.*))?$";
    private static final String SID_PATTERN = "(?i)^(.+)(?:sid=[0-9a-zA-Z]{32})(?:&(.*))?$";
    private static final String ASPSESSION_PATTERN = "(?i)^(.+)(?:ASPSESSIONID[a-zA-Z]{8}=[a-zA-Z]{24})(?:&(.*))?$";

    @Override
    public String canonicalize(String url) {
        url = this.doStripRegexMatch(url, BASE_PATTERN);
        url = this.doStripRegexMatch(url, SID_PATTERN);
        url = this.doStripRegexMatch(url, ASPSESSION_PATTERN);
        return url;
    }
}

