/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.credential;

import java.io.Serializable;
import java.util.Iterator;
import java.util.logging.Logger;
import org.archive.modules.CrawlURI;
import org.archive.modules.net.CrawlServer;
import org.archive.modules.net.ServerCache;

public abstract class Credential
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final Logger logger = Logger.getLogger(Credential.class.getName());
    protected String domain = "";

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void attach(CrawlURI curi) {
        curi.getCredentials().add(this);
    }

    public boolean detach(CrawlURI curi) {
        return curi.getCredentials().remove(this);
    }

    public boolean detachAll(CrawlURI curi) {
        boolean result = false;
        Iterator<Credential> iter = curi.getCredentials().iterator();
        while (iter.hasNext()) {
            Credential cred = iter.next();
            if (cred.getClass() != this.getClass()) continue;
            iter.remove();
            result = true;
        }
        return result;
    }

    public abstract boolean isPrerequisite(CrawlURI var1);

    public abstract boolean hasPrerequisite(CrawlURI var1);

    public abstract String getPrerequisite(CrawlURI var1);

    public abstract String getKey();

    public abstract boolean isEveryTime();

    public abstract boolean isPost();

    public boolean rootUriMatch(ServerCache cache, CrawlURI curi) {
        String cd = this.getDomain();
        CrawlServer serv = cache.getServerFor(curi.getUURI());
        String serverName = serv.getName();
        logger.fine("RootURI: Comparing " + serverName + " " + cd);
        return cd != null && serverName != null && serverName.equalsIgnoreCase(cd);
    }
}

