/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.credential;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.archive.modules.CrawlURI;
import org.archive.modules.credential.Credential;
import org.archive.modules.credential.HtmlFormCredential;
import org.archive.modules.credential.HttpAuthenticationCredential;
import org.archive.spring.HasKeyedProperties;
import org.archive.spring.KeyedProperties;

public class CredentialStore
implements Serializable,
HasKeyedProperties {
    private static final long serialVersionUID = 3L;
    private static Logger logger = Logger.getLogger("org.archive.crawler.datamodel.CredentialStore");
    protected KeyedProperties kp = new KeyedProperties();
    private static final List<Class<?>> credentialTypes;

    public KeyedProperties getKeyedProperties() {
        return this.kp;
    }

    public Map<String, Credential> getCredentials() {
        return (Map)this.kp.get("credentials");
    }

    public void setCredentials(Map<String, Credential> map) {
        this.kp.put((Object)"credentials", map);
    }

    public CredentialStore() {
        this.setCredentials(new TreeMap<String, Credential>());
    }

    public static List<Class<?>> getCredentialTypes() {
        return credentialTypes;
    }

    public Collection<Credential> getAll() {
        Map<String, Credential> map = this.getCredentials();
        return map.values();
    }

    public Credential get(Object context, String name) {
        return this.getCredentials().get(name);
    }

    public Set<Credential> subset(CrawlURI context, Class<?> type) {
        return this.subset(context, type, null);
    }

    public Set<Credential> subset(CrawlURI context, Class<?> type, String rootUri) {
        HashSet<Credential> result = null;
        for (Credential c : this.getAll()) {
            String cd;
            if (!type.isInstance(c) || rootUri != null && ((cd = c.getDomain()) == null || !rootUri.equalsIgnoreCase(cd))) continue;
            if (result == null) {
                result = new HashSet<Credential>();
            }
            result.add(c);
        }
        return result;
    }

    static {
        Class[] tmp = new Class[]{HtmlFormCredential.class, HttpAuthenticationCredential.class};
        credentialTypes = Collections.unmodifiableList(Arrays.asList(tmp));
    }
}

