/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.credential;

import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.apache.commons.httpclient.URIException;
import org.archive.modules.CrawlURI;
import org.archive.modules.credential.Credential;
import org.archive.net.UURI;
import org.archive.net.UURIFactory;

public class HtmlFormCredential
extends Credential {
    private static final long serialVersionUID = -4L;
    private static final Logger logger = Logger.getLogger(HtmlFormCredential.class.getName());
    protected String loginUri = "";
    protected Map<String, String> formItems = new TreeMap<String, String>();
    protected Method httpMethod = Method.POST;

    public String getLoginUri() {
        return this.loginUri;
    }

    public void setLoginUri(String loginUri) {
        this.loginUri = loginUri;
    }

    public Map<String, String> getFormItems() {
        return this.formItems;
    }

    public void setFormItems(Map<String, String> formItems) {
        this.formItems = formItems;
    }

    public Method getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(Method method) {
        this.httpMethod = method;
    }

    @Override
    public boolean isPrerequisite(CrawlURI curi) {
        boolean result = false;
        String curiStr = curi.getUURI().toString();
        String loginUri = this.getPrerequisite(curi);
        if (loginUri != null) {
            try {
                UURI uuri = UURIFactory.getInstance((UURI)curi.getUURI(), (String)loginUri);
                if (uuri != null && curiStr != null && uuri.toString().equals(curiStr)) {
                    result = true;
                    if (!curi.isPrerequisite()) {
                        curi.setPrerequisite(true);
                        logger.fine(curi + " is prereq.");
                    }
                }
            }
            catch (URIException e) {
                logger.severe("Failed to uuri: " + curi + ", " + e.getMessage());
            }
        }
        return result;
    }

    @Override
    public boolean hasPrerequisite(CrawlURI curi) {
        return this.getPrerequisite(curi) != null;
    }

    @Override
    public String getPrerequisite(CrawlURI curi) {
        return this.getLoginUri();
    }

    @Override
    public String getKey() {
        return this.getLoginUri();
    }

    @Override
    public boolean isEveryTime() {
        return false;
    }

    @Override
    public boolean isPost() {
        return Method.POST.equals((Object)this.getHttpMethod());
    }

    public static enum Method {
        GET,
        POST;

    }
}

