/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.credential;

import java.util.Set;
import java.util.logging.Logger;
import org.archive.modules.CrawlURI;
import org.archive.modules.credential.Credential;

public class HttpAuthenticationCredential
extends Credential {
    private static final long serialVersionUID = 4L;
    private static Logger logger = Logger.getLogger(HttpAuthenticationCredential.class.getName());
    protected String realm = "Realm";
    protected String login = "login";
    protected String password = "password";

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public boolean isPrerequisite(CrawlURI curi) {
        return false;
    }

    @Override
    public boolean hasPrerequisite(CrawlURI curi) {
        return false;
    }

    @Override
    public String getPrerequisite(CrawlURI curi) {
        return null;
    }

    @Override
    public String getKey() {
        return this.getRealm();
    }

    @Override
    public boolean isEveryTime() {
        return true;
    }

    @Override
    public boolean isPost() {
        return false;
    }

    public static HttpAuthenticationCredential getByRealm(Set<Credential> rfc2617Credentials, String realm, CrawlURI context) {
        HttpAuthenticationCredential result = null;
        if (rfc2617Credentials == null || rfc2617Credentials.size() <= 0) {
            return result;
        }
        if (rfc2617Credentials != null && rfc2617Credentials.size() > 0) {
            for (HttpAuthenticationCredential httpAuthenticationCredential : rfc2617Credentials) {
                if (httpAuthenticationCredential.getRealm() == null || httpAuthenticationCredential.getRealm().isEmpty()) {
                    result = httpAuthenticationCredential;
                    break;
                }
                if (!httpAuthenticationCredential.getRealm().equals(realm)) continue;
                result = httpAuthenticationCredential;
                break;
            }
        }
        return result;
    }
}

