/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.deciderules;

import java.io.Serializable;
import org.archive.modules.CrawlURI;
import org.archive.modules.deciderules.DecideResult;
import org.archive.spring.HasKeyedProperties;
import org.archive.spring.KeyedProperties;

public abstract class DecideRule
implements Serializable,
HasKeyedProperties {
    protected KeyedProperties kp = new KeyedProperties();
    protected String comment;

    public KeyedProperties getKeyedProperties() {
        return this.kp;
    }

    public boolean getEnabled() {
        return (Boolean)this.kp.get("enabled");
    }

    public void setEnabled(boolean enabled) {
        this.kp.put((Object)"enabled", (Object)enabled);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public DecideRule() {
        this.setEnabled(true);
        this.comment = "";
    }

    public DecideResult decisionFor(CrawlURI uri) {
        if (!this.getEnabled()) {
            return DecideResult.NONE;
        }
        DecideResult result = this.innerDecide(uri);
        if (result == DecideResult.NONE) {
            return result;
        }
        return result;
    }

    protected abstract DecideResult innerDecide(CrawlURI var1);

    public DecideResult onlyDecision(CrawlURI uri) {
        return null;
    }

    public boolean accepts(CrawlURI uri) {
        return DecideResult.ACCEPT == this.decisionFor(uri);
    }
}

