/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.deciderules;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.modules.CrawlURI;
import org.archive.modules.SimpleFileLoggerProvider;
import org.archive.modules.deciderules.DecideResult;
import org.archive.modules.deciderules.DecideRule;
import org.archive.modules.net.CrawlHost;
import org.archive.modules.net.ServerCache;
import org.json.JSONObject;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.Lifecycle;

public class DecideRuleSequence
extends DecideRule
implements BeanNameAware,
Lifecycle {
    private static final Logger LOGGER = Logger.getLogger(DecideRuleSequence.class.getName());
    private static final long serialVersionUID = 3L;
    protected transient Logger fileLogger = null;
    protected boolean logExtraInfo;
    protected SimpleFileLoggerProvider loggerModule;
    protected ServerCache serverCache;
    protected String beanName;
    protected boolean isRunning;

    public DecideRuleSequence() {
        this.setLogToFile(false);
        this.logExtraInfo = false;
        this.isRunning = false;
    }

    public boolean getLogToFile() {
        return (Boolean)this.kp.get("logToFile");
    }

    public void setLogToFile(boolean enabled) {
        this.kp.put((Object)"logToFile", (Object)enabled);
    }

    public boolean getLogExtraInfo() {
        return this.logExtraInfo;
    }

    public void setLogExtraInfo(boolean logExtraInfo) {
        this.logExtraInfo = logExtraInfo;
    }

    public SimpleFileLoggerProvider getLoggerModule() {
        return this.loggerModule;
    }

    @Autowired
    public void setLoggerModule(SimpleFileLoggerProvider loggerModule) {
        this.loggerModule = loggerModule;
    }

    public List<DecideRule> getRules() {
        return (List)this.kp.get("rules");
    }

    public void setRules(List<DecideRule> rules) {
        this.kp.put((Object)"rules", rules);
    }

    public ServerCache getServerCache() {
        return this.serverCache;
    }

    @Autowired
    public void setServerCache(ServerCache serverCache) {
        this.serverCache = serverCache;
    }

    @Override
    public DecideResult innerDecide(CrawlURI uri) {
        DecideRule decisiveRule = null;
        int decisiveRuleNumber = -1;
        DecideResult result = DecideResult.NONE;
        List<DecideRule> rules = this.getRules();
        int max = rules.size();
        for (int i = 0; i < max; ++i) {
            DecideRule rule = rules.get(i);
            if (rule.onlyDecision(uri) == result) continue;
            DecideResult r = rule.decisionFor(uri);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("DecideRule #" + i + " " + rule.getClass().getName() + " returned " + (Object)((Object)r) + " for url: " + uri);
            }
            if (r == DecideResult.NONE) continue;
            result = r;
            decisiveRule = rule;
            decisiveRuleNumber = i;
        }
        this.decisionMade(uri, decisiveRule, decisiveRuleNumber, result);
        return result;
    }

    protected void decisionMade(CrawlURI uri, DecideRule decisiveRule, int decisiveRuleNumber, DecideResult result) {
        if (this.fileLogger != null) {
            JSONObject extraInfo = null;
            if (this.logExtraInfo) {
                CrawlHost crawlHost = this.getServerCache().getHostFor(uri.getUURI());
                String host = "-";
                if (crawlHost != null) {
                    host = crawlHost.fixUpName();
                }
                extraInfo = new JSONObject();
                extraInfo.put("hopPath", (Object)uri.getPathFromSeed());
                extraInfo.put("via", (Object)uri.getVia());
                extraInfo.put("seed", (Object)uri.getSourceTag());
                extraInfo.put("host", (Object)host);
            }
            this.fileLogger.info(decisiveRuleNumber + " " + decisiveRule.getClass().getSimpleName() + " " + (Object)((Object)result) + " " + uri + (extraInfo != null ? " " + extraInfo : ""));
        }
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void start() {
        if (this.getLogToFile() && this.fileLogger == null) {
            this.loggerModule.start();
            this.fileLogger = this.loggerModule.setupSimpleLog(this.getBeanName());
        }
        this.isRunning = true;
    }

    public void stop() {
        this.isRunning = false;
    }
}

