/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.deciderules;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.URIException;
import org.archive.modules.CrawlURI;
import org.archive.modules.deciderules.ExternalGeoLookupInterface;
import org.archive.modules.deciderules.PredicatedDecideRule;
import org.archive.modules.net.CrawlHost;
import org.archive.modules.net.ServerCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.xbill.DNS.Address;

public class ExternalGeoLocationDecideRule
extends PredicatedDecideRule {
    private static final long serialVersionUID = 3L;
    private static final Logger LOGGER = Logger.getLogger(ExternalGeoLocationDecideRule.class.getName());
    protected ExternalGeoLookupInterface lookup = null;
    protected List<String> countryCodes = new ArrayList<String>();
    protected ServerCache serverCache;

    public ExternalGeoLookupInterface getLookup() {
        return this.lookup;
    }

    public void setLookup(ExternalGeoLookupInterface lookup) {
        this.lookup = lookup;
    }

    public List<String> getCountryCodes() {
        return this.countryCodes;
    }

    public void setCountryCodes(List<String> codes) {
        this.countryCodes = codes;
    }

    public ServerCache getServerCache() {
        return this.serverCache;
    }

    @Autowired
    public void setServerCache(ServerCache serverCache) {
        this.serverCache = serverCache;
    }

    @Override
    protected boolean evaluate(CrawlURI uri) {
        ExternalGeoLookupInterface impl = this.getLookup();
        if (impl == null) {
            return false;
        }
        CrawlHost crawlHost = null;
        try {
            String host = uri.getUURI().getHost();
            crawlHost = this.serverCache.getHostFor(host);
            if (crawlHost.getCountryCode() != null) {
                return this.countryCodes.contains(crawlHost.getCountryCode());
            }
            InetAddress address = crawlHost.getIP();
            if (address == null) {
                address = Address.getByName((String)host);
            }
            crawlHost.setCountryCode(impl.lookup(address));
            if (this.countryCodes.contains(crawlHost.getCountryCode())) {
                LOGGER.fine("Country Code Lookup:  " + host + crawlHost.getCountryCode());
                return true;
            }
        }
        catch (UnknownHostException e) {
            LOGGER.log(Level.FINE, "Failed dns lookup " + uri, e);
            if (crawlHost != null) {
                crawlHost.setCountryCode("--");
            }
        }
        catch (URIException e) {
            LOGGER.log(Level.FINE, "Failed to parse hostname " + uri, e);
        }
        return false;
    }
}

