/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.deciderules;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.modules.CrawlURI;
import org.archive.modules.deciderules.PredicatedDecideRule;
import org.archive.net.PublicSuffixes;
import org.archive.net.UURI;

public class HopCrossesAssignmentLevelDomainDecideRule
extends PredicatedDecideRule {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(HopCrossesAssignmentLevelDomainDecideRule.class.getName());

    @Override
    protected boolean evaluate(CrawlURI uri) {
        UURI via = uri.getVia();
        if (via == null) {
            return false;
        }
        try {
            String ald = this.getAssignmentLevelSurt(uri.getUURI());
            String viaAld = this.getAssignmentLevelSurt(via);
            if (ald != null && !ald.equals(viaAld)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("rule matched for \"" + ald + "\" vs. \"" + viaAld + "\"");
                }
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "uri=" + uri + " via=" + via, e);
        }
        return false;
    }

    private String getAssignmentLevelSurt(UURI uuri) {
        String surt = uuri.getSurtForm().replaceFirst(".*://\\((.*?)\\).*", "$1");
        return PublicSuffixes.reduceSurtToAssignmentLevel((String)surt);
    }
}

