/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.deciderules;

import java.net.InetAddress;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.modules.CrawlURI;
import org.archive.modules.deciderules.PredicatedDecideRule;
import org.archive.modules.net.CrawlHost;
import org.archive.modules.net.ServerCache;
import org.springframework.beans.factory.annotation.Autowired;

public class IpAddressSetDecideRule
extends PredicatedDecideRule {
    private static final Logger logger = Logger.getLogger(IpAddressSetDecideRule.class.getName());
    private static final long serialVersionUID = -3670434739183271441L;
    private Set<String> ipAddresses;
    protected transient ServerCache serverCache;

    public Set<String> getIpAddresses() {
        return Collections.unmodifiableSet(this.ipAddresses);
    }

    public void setIpAddresses(Set<String> ipAddresses) {
        this.ipAddresses = ipAddresses;
    }

    @Override
    protected boolean evaluate(CrawlURI curi) {
        String hostAddress = this.getHostAddress(curi);
        return hostAddress != null && this.ipAddresses.contains(hostAddress.intern());
    }

    public ServerCache getServerCache() {
        return this.serverCache;
    }

    @Autowired
    public void setServerCache(ServerCache serverCache) {
        this.serverCache = serverCache;
    }

    protected String getHostAddress(CrawlURI curi) {
        if (curi.getServerIP() != null) {
            return curi.getServerIP();
        }
        String addr = null;
        try {
            CrawlHost crlh = this.getServerCache().getHostFor(curi.getUURI());
            if (crlh == null) {
                return null;
            }
            InetAddress inetadd = crlh.getIP();
            if (inetadd == null) {
                return null;
            }
            addr = inetadd.getHostAddress();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error looking up IP for URI " + curi.getURI(), e);
        }
        return addr;
    }
}

