/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.deciderules;

import java.util.regex.Pattern;
import org.archive.modules.deciderules.MatchesRegexDecideRule;

public class MatchesFilePatternDecideRule
extends MatchesRegexDecideRule {
    private static final long serialVersionUID = 3L;

    public Preset getUsePreset() {
        return (Preset)((Object)this.kp.get("usePreset"));
    }

    public void setUsePreset(Preset preset) {
        this.kp.put((Object)"usePreset", (Object)preset);
    }

    public MatchesFilePatternDecideRule() {
        this.setUsePreset(Preset.ALL);
    }

    @Override
    public Pattern getRegex() {
        Preset preset = this.getUsePreset();
        if (preset == Preset.CUSTOM) {
            return super.getRegex();
        }
        return preset.getPattern();
    }

    public static enum Preset {
        ALL(".*(?i)(\\.(bmp|gif|jpe?g|png|svg|tiff?|aac|aiff?|m3u|m4a|midi?|mp2|mp3|mp4|mpa|ogg|ra|ram|wav|wma|asf|asx|avi|flv|mov|mp4|mpeg|mpg|qt|ram|rm|smil|wmv|doc|pdf|ppt|swf))$"),
        IMAGES(".*(?i)(\\.(bmp|gif|jpe?g|png|svg|tiff?))$"),
        AUDIO(".*(?i)(\\.(aac|aiff?|m3u|m4a|midi?|mp2|mp3|mp4|mpa|ogg|ra|ram|wav|wma))$"),
        VIDEO(".*(?i)(\\.(asf|asx|avi|flv|mov|mp4|mpeg|mpg|qt|ram|rm|smil|wmv))$"),
        MISC(".*(?i)(\\.(doc|pdf|ppt|swf))$"),
        CUSTOM(null);

        private final Pattern pattern;

        private Preset(String regex) {
            this.pattern = regex == null ? null : Pattern.compile(regex);
        }

        public Pattern getPattern() {
            return this.pattern;
        }
    }
}

