/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.deciderules;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.archive.modules.CrawlURI;
import org.archive.modules.deciderules.PredicatedDecideRule;
import org.archive.util.InterruptibleCharSequence;

public class MatchesListRegexDecideRule
extends PredicatedDecideRule {
    private static final long serialVersionUID = 3L;
    private static final Logger logger = Logger.getLogger(MatchesListRegexDecideRule.class.getName());

    public long getTimeoutPerRegexSeconds() {
        return (Long)this.kp.get("timeout");
    }

    public void setTimeoutPerRegexSeconds(long timeoutPerRegexSeconds) {
        this.kp.put((Object)"timeout", (Object)timeoutPerRegexSeconds);
    }

    public List<Pattern> getRegexList() {
        return (List)this.kp.get("regexList");
    }

    public void setRegexList(List<Pattern> patterns) {
        this.kp.put((Object)"regexList", patterns);
    }

    public boolean getListLogicalOr() {
        return (Boolean)this.kp.get("listLogicalOr");
    }

    public void setListLogicalOr(boolean listLogicalOr) {
        this.kp.put((Object)"listLogicalOr", (Object)listLogicalOr);
    }

    public MatchesListRegexDecideRule() {
        this.setTimeoutPerRegexSeconds(0L);
        this.setRegexList(new ArrayList<Pattern>());
        this.setListLogicalOr(true);
    }

    @Override
    protected boolean evaluate(CrawlURI uri) {
        List<Pattern> regexes = this.getRegexList();
        if (regexes.size() == 0) {
            return false;
        }
        String str = uri.toString();
        boolean listLogicOR = this.getListLogicalOr();
        for (Pattern p : regexes) {
            boolean matches = false;
            if (this.getTimeoutPerRegexSeconds() <= 0L) {
                matches = p.matcher(str).matches();
            } else {
                InterruptibleCharSequence interruptible = new InterruptibleCharSequence((CharSequence)str);
                FutureTask<Boolean> matchesFuture = new FutureTask<Boolean>(() -> p.matcher((CharSequence)interruptible).matches());
                ForkJoinPool.commonPool().submit(matchesFuture);
                try {
                    matches = matchesFuture.get(this.getTimeoutPerRegexSeconds(), TimeUnit.SECONDS);
                }
                catch (TimeoutException e) {
                    matchesFuture.cancel(true);
                    logger.warning("Timed out after " + this.getTimeoutPerRegexSeconds() + " seconds waiting for '" + p + "' to match.");
                }
                catch (InterruptedException e) {
                    matchesFuture.cancel(true);
                    logger.warning("InterruptedException while waiting for '" + p + "' to match.");
                }
                catch (ExecutionException e) {
                    matchesFuture.cancel(true);
                    logger.warning("ExecutionException while waiting for '" + p + "' to match: " + e.getMessage());
                }
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Tested '" + str + "' match with regex '" + p.pattern() + " and result was " + matches);
            }
            if (matches) {
                if (!listLogicOR) continue;
                logger.fine("Matched: " + str);
                return true;
            }
            if (listLogicOR) continue;
            return false;
        }
        return !listLogicOR;
    }
}

