/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.deciderules;

import org.archive.modules.CrawlURI;
import org.archive.modules.deciderules.PredicatedDecideRule;

public class MatchesStatusCodeDecideRule
extends PredicatedDecideRule {
    public static final Integer DEFAULT_LOWER_BOUND = new Integer(0);
    public static final Integer DEFAULT_UPPER_BOUND = new Integer(600);

    public MatchesStatusCodeDecideRule() {
        this.kp.put((Object)"lowerBound", (Object)DEFAULT_LOWER_BOUND);
        this.kp.put((Object)"upperBound", (Object)DEFAULT_UPPER_BOUND);
    }

    public void setLowerBound(Integer statusCode) {
        this.kp.put((Object)"lowerBound", (Object)statusCode);
    }

    public Integer getLowerBound() {
        Object value = this.kp.get("lowerBound");
        if (value != null) {
            return (Integer)value;
        }
        return null;
    }

    public void setUpperBound(Integer statusCode) {
        this.kp.put((Object)"upperBound", (Object)statusCode);
    }

    public Integer getUpperBound() {
        Object value = this.kp.get("upperBound");
        if (value != null) {
            return (Integer)value;
        }
        return null;
    }

    @Override
    protected boolean evaluate(CrawlURI uri) {
        boolean value = false;
        int statusCode = uri.getFetchStatus();
        if (statusCode >= this.getLowerBound() && statusCode <= this.getUpperBound()) {
            value = true;
        }
        return value;
    }
}

