/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.deciderules;

import java.util.regex.Matcher;
import org.archive.modules.CrawlURI;
import org.archive.modules.deciderules.DecideResult;
import org.archive.modules.deciderules.DecideRule;
import org.archive.util.TextUtils;

public class PathologicalPathDecideRule
extends DecideRule {
    private static final long serialVersionUID = 3L;

    public int getMaxRepetitions() {
        return (Integer)this.kp.get("maxRepetitions");
    }

    public void setMaxRepetitions(int maxRepetitions) {
        this.kp.put((Object)"maxRepetitions", (Object)maxRepetitions);
    }

    public PathologicalPathDecideRule() {
        this.setMaxRepetitions(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected DecideResult innerDecide(CrawlURI uri) {
        int maxRep = this.getMaxRepetitions();
        Matcher m = TextUtils.getMatcher((String)this.constructRegex(maxRep), (CharSequence)uri.getUURI().toString());
        try {
            if (m.matches()) {
                DecideResult decideResult = DecideResult.REJECT;
                return decideResult;
            }
            DecideResult decideResult = DecideResult.NONE;
            return decideResult;
        }
        finally {
            TextUtils.recycleMatcher((Matcher)m);
        }
    }

    protected String constructRegex(int rep) {
        return rep == 0 ? null : ".*?/(.*?/)\\1{" + rep + ",}.*";
    }
}

