/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.deciderules;

import java.util.logging.Logger;
import org.archive.modules.CrawlURI;
import org.archive.modules.deciderules.PredicatedDecideRule;

public class ResourceNoLongerThanDecideRule
extends PredicatedDecideRule {
    private static final long serialVersionUID = -8774160016195991876L;
    private static final Logger logger = Logger.getLogger(ResourceNoLongerThanDecideRule.class.getName());
    public static final int HEADER_PREDICTS_MISSING = -1;

    public boolean getUseHeaderLength() {
        return (Boolean)this.kp.get("useHeaderLength");
    }

    public void setUseHeaderLength(boolean useHeaderLength) {
        this.kp.put((Object)"useHeaderLength", (Object)useHeaderLength);
    }

    public long getContentLengthThreshold() {
        return (Long)this.kp.get("contentLengthThreshold");
    }

    public void setContentLengthThreshold(long threshold) {
        this.kp.put((Object)"contentLengthThreshold", (Object)threshold);
    }

    public ResourceNoLongerThanDecideRule() {
        this.setUseHeaderLength(true);
        this.setContentLengthThreshold(-1L);
    }

    @Override
    protected boolean evaluate(CrawlURI curi) {
        int contentlength = -1;
        if (this.getUseHeaderLength()) {
            String newContentlength = null;
            if (curi.getHttpResponseHeader("content-length") != null) {
                newContentlength = curi.getHttpResponseHeader("content-length");
            }
            if (newContentlength != null && newContentlength.length() > 0) {
                try {
                    contentlength = Integer.parseInt(newContentlength);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (contentlength == -1) {
                return false;
            }
        } else {
            contentlength = (int)curi.getContentSize();
        }
        return this.test(contentlength);
    }

    protected boolean test(int contentlength) {
        return (long)contentlength < this.getContentLengthThreshold();
    }
}

