/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.deciderules;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.archive.modules.CrawlURI;
import org.archive.modules.deciderules.DecideResult;
import org.archive.modules.deciderules.PredicatedDecideRule;

public class SchemeNotInSetDecideRule
extends PredicatedDecideRule {
    private static final long serialVersionUID = 3L;
    protected Set<String> schemes;

    public SchemeNotInSetDecideRule() {
        this.setDecision(DecideResult.REJECT);
        this.schemes = new HashSet<String>();
        this.schemes.addAll(Arrays.asList("http", "https", "ftp", "dns", "whois", "sftp"));
    }

    public Set<String> getSchemes() {
        return this.schemes;
    }

    public void setSchemes(Set<String> schemes) {
        this.schemes = schemes;
    }

    @Override
    protected boolean evaluate(CrawlURI uri) {
        return !this.schemes.contains(uri.getUURI().getScheme());
    }
}

