/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.deciderules;

import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.io.IOUtils;
import org.archive.io.ReadSource;
import org.archive.modules.CrawlURI;
import org.archive.modules.deciderules.DecideResult;
import org.archive.modules.deciderules.DecideRule;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ScriptedDecideRule
extends DecideRule
implements ApplicationContextAware,
InitializingBean {
    private static final long serialVersionUID = 3L;
    private static final Logger logger = Logger.getLogger(ScriptedDecideRule.class.getName());
    protected String engineName = "beanshell";
    protected ReadSource scriptSource = null;
    protected boolean isolateThreads = true;
    protected ApplicationContext appCtx;
    protected transient ThreadLocal<ScriptEngine> threadEngine = new ThreadLocal();
    protected transient ScriptEngine sharedEngine;

    public String getEngineName() {
        return this.engineName;
    }

    public void setEngineName(String name) {
        this.engineName = name;
    }

    public ReadSource getScriptSource() {
        return this.scriptSource;
    }

    @Required
    public void setScriptSource(ReadSource scriptSource) {
        this.scriptSource = scriptSource;
    }

    public boolean getIsolateThreads() {
        return this.isolateThreads;
    }

    public void setIsolateThreads(boolean isolateThreads) {
        this.isolateThreads = isolateThreads;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.appCtx = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        if (null == new ScriptEngineManager().getEngineByName(this.engineName)) {
            throw new BeanInitializationException("named ScriptEngine not available");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DecideResult innerDecide(CrawlURI uri) {
        ScriptEngine engine;
        ScriptEngine scriptEngine = engine = this.getEngine();
        synchronized (scriptEngine) {
            DecideResult decideResult;
            try {
                engine.put("object", uri);
                engine.put("appCtx", this.appCtx);
                decideResult = (DecideResult)((Object)engine.eval("decisionFor(object)"));
                engine.put("object", null);
                engine.put("appCtx", null);
            }
            catch (ScriptException e) {
                DecideResult decideResult2;
                try {
                    logger.log(Level.WARNING, e.getMessage(), e);
                    decideResult2 = DecideResult.NONE;
                    engine.put("object", null);
                    engine.put("appCtx", null);
                }
                catch (Throwable throwable) {
                    engine.put("object", null);
                    engine.put("appCtx", null);
                    throw throwable;
                }
                return decideResult2;
            }
            return decideResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ScriptEngine getEngine() {
        if (this.getIsolateThreads()) {
            ScriptEngine engine = this.threadEngine.get();
            if (engine == null) {
                engine = this.newEngine();
                this.threadEngine.set(engine);
            }
            return engine;
        }
        ScriptedDecideRule scriptedDecideRule = this;
        synchronized (scriptedDecideRule) {
            if (this.sharedEngine == null) {
                this.sharedEngine = this.newEngine();
            }
        }
        return this.sharedEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ScriptEngine newEngine() {
        ScriptEngine interpreter = new ScriptEngineManager().getEngineByName(this.engineName);
        interpreter.put("self", this);
        interpreter.put("context", this.appCtx);
        Reader reader = null;
        try {
            reader = this.getScriptSource().obtainReader();
            interpreter.eval(reader);
        }
        catch (ScriptException e) {
            logger.log(Level.SEVERE, "script problem", e);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        return interpreter;
    }
}

