/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.deciderules;

import java.util.logging.Logger;
import org.archive.modules.CrawlURI;
import org.archive.modules.deciderules.DecideResult;
import org.archive.modules.deciderules.PredicatedDecideRule;

public class TooManyPathSegmentsDecideRule
extends PredicatedDecideRule {
    private static final long serialVersionUID = 3L;
    private static final Logger logger = Logger.getLogger(TooManyPathSegmentsDecideRule.class.getName());

    public int getMaxPathDepth() {
        return (Integer)this.kp.get("maxPathDepth");
    }

    public void setMaxPathDepth(int maxPathDepth) {
        this.kp.put((Object)"maxPathDepth", (Object)maxPathDepth);
    }

    public TooManyPathSegmentsDecideRule() {
        this.setDecision(DecideResult.REJECT);
        this.setMaxPathDepth(20);
    }

    @Override
    protected boolean evaluate(CrawlURI curi) {
        String uriPath = curi.getUURI().getEscapedPath();
        if (uriPath == null) {
            return false;
        }
        int count = 0;
        int threshold = this.getMaxPathDepth();
        for (int i = 0; i < uriPath.length(); ++i) {
            if (uriPath.charAt(i) == '/') {
                ++count;
            }
            if (count <= threshold) continue;
            return true;
        }
        return false;
    }
}

