/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.deciderules;

import org.archive.modules.CrawlURI;
import org.archive.modules.deciderules.PredicatedDecideRule;
import org.archive.modules.extractor.Hop;

public class TransclusionDecideRule
extends PredicatedDecideRule {
    private static final long serialVersionUID = -3975688876990558918L;

    public int getMaxTransHops() {
        return (Integer)this.kp.get("maxTransHops");
    }

    public void setMaxTransHops(int maxTransHops) {
        this.kp.put((Object)"maxTransHops", (Object)maxTransHops);
    }

    public int getMaxSpeculativeHops() {
        return (Integer)this.kp.get("maxSpeculativeHops");
    }

    public void setMaxSpeculativeHops(int maxSpeculativeHops) {
        this.kp.put((Object)"maxSpeculativeHops", (Object)maxSpeculativeHops);
    }

    public TransclusionDecideRule() {
        this.setMaxTransHops(2);
        this.setMaxSpeculativeHops(1);
    }

    @Override
    protected boolean evaluate(CrawlURI curi) {
        char c;
        String hopsPath = curi.getPathFromSeed();
        if (hopsPath == null || hopsPath.length() == 0) {
            return false;
        }
        int allCount = 0;
        int nonrefCount = 0;
        int specCount = 0;
        for (int i = hopsPath.length() - 1; i >= 0 && (c = hopsPath.charAt(i)) != Hop.NAVLINK.getHopChar() && c != Hop.SUBMIT.getHopChar() && c != Hop.MANIFEST.getHopChar(); --i) {
            ++allCount;
            if (c != Hop.REFER.getHopChar()) {
                ++nonrefCount;
            }
            if (c != Hop.SPECULATIVE.getHopChar()) continue;
            ++specCount;
        }
        if (allCount <= 0) {
            return false;
        }
        if (specCount > this.getMaxSpeculativeHops()) {
            return false;
        }
        return nonrefCount <= this.getMaxTransHops();
    }
}

