/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.deciderules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.archive.modules.CrawlURI;
import org.archive.modules.deciderules.PredicatedDecideRule;
import org.archive.url.UsableURI;
import org.archive.util.SurtPrefixSet;
import org.springframework.beans.factory.annotation.Required;

public class ViaSurtPrefixedDecideRule
extends PredicatedDecideRule {
    private static final long serialVersionUID = 1L;
    protected SurtPrefixSet surtPrefixes = new SurtPrefixSet();

    public List<String> getSurtPrefixes() {
        return new ArrayList<String>((Collection<String>)this.surtPrefixes);
    }

    @Required
    public void setSurtPrefixes(List<String> surtPrefixes) {
        this.surtPrefixes.clear();
        if (surtPrefixes != null) {
            for (String surt : surtPrefixes) {
                this.surtPrefixes.considerAsAddDirective(surt);
            }
        }
    }

    @Override
    protected boolean evaluate(CrawlURI uri) {
        if (uri.getVia() != null && this.getSurtPrefixes() != null) {
            return this.surtPrefixes.containsPrefixOf(SurtPrefixSet.getCandidateSurt((UsableURI)uri.getVia()));
        }
        return false;
    }
}

