/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.deciderules.recrawl;

import org.archive.modules.CrawlURI;
import org.archive.modules.deciderules.DecideResult;
import org.archive.modules.deciderules.PredicatedDecideRule;
import org.archive.modules.revisit.RevisitProfile;

public class IdenticalDigestDecideRule
extends PredicatedDecideRule {
    private static final long serialVersionUID = 4275993790856626949L;

    public IdenticalDigestDecideRule() {
        this.setDecision(DecideResult.REJECT);
    }

    @Override
    protected boolean evaluate(CrawlURI curi) {
        return IdenticalDigestDecideRule.hasIdenticalDigest(curi);
    }

    public static boolean hasIdenticalDigest(CrawlURI curi) {
        RevisitProfile revisit = curi.getRevisitProfile();
        if (revisit == null) {
            return false;
        }
        return revisit.getProfileName().equals("http://netpreserve.org/warc/1.0/revisit/identical-payload-digest");
    }
}

