/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.deciderules.surt;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.archive.checkpointing.Checkpoint;
import org.archive.checkpointing.Checkpointable;
import org.archive.io.ReadSource;
import org.archive.modules.CrawlURI;
import org.archive.modules.deciderules.DecideResult;
import org.archive.modules.deciderules.PredicatedDecideRule;
import org.archive.modules.seeds.SeedListener;
import org.archive.modules.seeds.SeedModule;
import org.archive.net.UURI;
import org.archive.spring.ConfigFile;
import org.archive.spring.ConfigPath;
import org.archive.url.UsableURI;
import org.archive.util.SurtPrefixSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextStartedEvent;

public class SurtPrefixedDecideRule
extends PredicatedDecideRule
implements SeedListener,
ApplicationListener<ApplicationEvent>,
Checkpointable,
BeanNameAware {
    private static final long serialVersionUID = 3L;
    private static final Logger logger = Logger.getLogger(SurtPrefixedDecideRule.class.getName());
    protected ReadSource surtsSource = null;
    protected boolean seedsAsSurtPrefixes = true;
    protected ConfigFile surtsDumpFile = new ConfigFile("surtsDumpFile", "${launchId}/surts.dump");
    protected SeedModule seeds;
    protected SurtPrefixSet surtPrefixes;
    private static final String DEFAULT_ACCEPT_ADD_PREFIX_DIRECTIVE = "+";
    private static final String DEFAULT_REJECT_ADD_PREFIX_DIRECTIVE = "-";
    protected String beanName;
    protected Checkpoint recoveryCheckpoint;

    public ConfigFile getSurtsSourceFile() {
        if (this.getSurtsSource() instanceof ConfigFile) {
            return (ConfigFile)this.getSurtsSource();
        }
        return null;
    }

    public void setSurtsSourceFile(ConfigFile cp) {
        this.setSurtsSource((ReadSource)cp);
    }

    public ReadSource getSurtsSource() {
        return this.surtsSource;
    }

    public void setSurtsSource(ReadSource surtsSource) {
        this.surtsSource = surtsSource;
    }

    public boolean getSeedsAsSurtPrefixes() {
        return this.seedsAsSurtPrefixes;
    }

    public void setSeedsAsSurtPrefixes(boolean seedsAsSurtPrefixes) {
        this.seedsAsSurtPrefixes = seedsAsSurtPrefixes;
    }

    public ConfigFile getSurtsDumpFile() {
        return this.surtsDumpFile;
    }

    public void setSurtsDumpFile(ConfigFile cp) {
        this.surtsDumpFile.merge((ConfigPath)cp);
    }

    public boolean getAlsoCheckVia() {
        return (Boolean)this.kp.get("alsoCheckVia");
    }

    public void setAlsoCheckVia(boolean checkVia) {
        this.kp.put((Object)"alsoCheckVia", (Object)checkVia);
    }

    public SeedModule getSeeds() {
        return this.seeds;
    }

    @Autowired
    public void setSeeds(SeedModule seeds) {
        this.seeds = seeds;
        if (seeds != null) {
            seeds.addSeedListener(this);
        }
    }

    public SurtPrefixedDecideRule() {
        this.setAlsoCheckVia(false);
        this.surtPrefixes = new SurtPrefixSet();
    }

    @Override
    public void concludedSeedBatch() {
        this.dumpSurtPrefixSet();
    }

    @Override
    protected boolean evaluate(CrawlURI uri) {
        if (this.getAlsoCheckVia() && this.innerDecide(uri.getVia())) {
            return true;
        }
        return this.innerDecide(uri.getUURI());
    }

    private boolean innerDecide(UURI uuri) {
        String candidateSurt = SurtPrefixSet.getCandidateSurt((UsableURI)uuri);
        if (candidateSurt == null) {
            return false;
        }
        return this.surtPrefixes.containsPrefixOf(candidateSurt);
    }

    protected void readPrefixes() {
        this.buildSurtPrefixSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dumpSurtPrefixSet() {
        String dumpPath = this.getSurtsDumpFile().getPath();
        if (!StringUtils.isEmpty((String)dumpPath)) {
            File dump = this.getSurtsDumpFile().getFile();
            try (FileWriter fw = new FileWriter(dump);){
                this.surtPrefixes.exportTo(fw);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    protected void buildSurtPrefixSet() {
        if (this.getSurtsSource() != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("reading surt prefixes from " + this.getSurtsSource());
            }
            Reader reader = this.getSurtsSource().obtainReader();
            try {
                this.surtPrefixes.importFromMixed(reader, true);
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
        }
    }

    @Override
    public void addedSeed(CrawlURI curi) {
        if (this.getSeedsAsSurtPrefixes()) {
            this.surtPrefixes.add(this.prefixFrom(curi.getURI()));
        }
    }

    protected String prefixFrom(String uri) {
        return SurtPrefixSet.prefixFromPlainForceHttp((String)uri);
    }

    @Override
    public boolean nonseedLine(String line) {
        String effectiveDirective = this.getEffectiveAddDirective();
        if (line.startsWith(effectiveDirective)) {
            return this.surtPrefixes.considerAsAddDirective(line.substring(effectiveDirective.length()));
        }
        return false;
    }

    private String getEffectiveAddDirective() {
        if (this.getDecision() == DecideResult.ACCEPT) {
            return DEFAULT_ACCEPT_ADD_PREFIX_DIRECTIVE;
        }
        if (this.getDecision() == DecideResult.REJECT) {
            return DEFAULT_REJECT_ADD_PREFIX_DIRECTIVE;
        }
        throw new IllegalArgumentException("decision must be ACCEPT or REJECT");
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextStartedEvent) {
            if (this.recoveryCheckpoint != null) {
                JSONObject json = this.recoveryCheckpoint.loadJson(this.beanName);
                try {
                    JSONArray jsonArray = json.getJSONArray("surtPrefixes");
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        this.surtPrefixes.add(jsonArray.getString(i));
                    }
                }
                catch (JSONException e) {
                    throw new IllegalStateException(e);
                }
            } else {
                this.readPrefixes();
            }
        }
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void startCheckpoint(Checkpoint checkpointInProgress) {
    }

    public void doCheckpoint(Checkpoint checkpointInProgress) throws IOException {
        try {
            JSONObject json = new JSONObject();
            json.put("surtPrefixes", (Collection)this.surtPrefixes);
            checkpointInProgress.saveJson(this.beanName, json);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public void finishCheckpoint(Checkpoint checkpointInProgress) {
    }

    public void setRecoveryCheckpoint(Checkpoint recoveryCheckpoint) {
        this.recoveryCheckpoint = recoveryCheckpoint;
    }
}

