/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.extractor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.archive.modules.extractor.ExtractorJS;

public class ConfigurableExtractorJS
extends ExtractorJS {
    private List<String> rejectRelativeMatchingRegexList;
    private List<Pattern> rejectRelativeMatchingRegexListPatterns;
    private Set<String> rejectRelativeIgnoreSet;

    public ConfigurableExtractorJS() {
        this.setStrict(false);
        this.setMaximumCandidateLength(-1);
        this.rejectRelativeMatchingRegexList = new ArrayList<String>();
        this.rejectRelativeIgnoreSet = new HashSet<String>();
    }

    public boolean getStrict() {
        return (Boolean)this.kp.get("strictMode");
    }

    public void setStrict(boolean strict) {
        this.kp.put((Object)"strictMode", (Object)strict);
    }

    public int getMaximumCandidateLength() {
        return (Integer)this.kp.get("maximumCandidateLength");
    }

    public void setMaximumCandidateLength(int maximumCandidateLength) {
        this.kp.put((Object)"maximumCandidateLength", (Object)maximumCandidateLength);
    }

    public List<String> getRejectRelativeMatchingRegexList() {
        return this.rejectRelativeMatchingRegexList;
    }

    public void setRejectRelativeMatchingRegexList(List<String> patterns) {
        this.rejectRelativeMatchingRegexList = patterns;
        this.rejectRelativeMatchingRegexListPatterns = new ArrayList<Pattern>();
        for (String p : patterns) {
            this.rejectRelativeMatchingRegexListPatterns.add(Pattern.compile(p, 2));
        }
    }

    public void addRejectRelativeMatchingRegex(String pattern) {
        this.rejectRelativeMatchingRegexListPatterns.add(Pattern.compile(pattern, 2));
    }

    public List<String> getRejectRelativeIgnoreList() {
        return this.rejectRelativeIgnoreSet.stream().collect(Collectors.toList());
    }

    public void setRejectRelativeIgnoreList(Set<String> ignoreStrings) {
        this.rejectRelativeIgnoreSet.clear();
        this.rejectRelativeIgnoreSet.addAll(ignoreStrings);
    }

    public void addRejectRelativeIgnoreList(String ignoreString) {
        this.rejectRelativeIgnoreSet.add(ignoreString);
    }

    @Override
    protected boolean shouldAddUri(String candidate) {
        return this.passesMaxLength(candidate) && this.passesStrictMode(candidate) && super.shouldAddUri(candidate) && !this.isOnRejectList(candidate);
    }

    protected boolean passesMaxLength(String candidate) {
        int max = this.getMaximumCandidateLength();
        return max <= 0 || candidate.length() <= max;
    }

    protected boolean passesStrictMode(String candidate) {
        return !this.getStrict() || this.hasScheme(candidate);
    }

    protected boolean hasScheme(String candidate) {
        return candidate.startsWith("http://") || candidate.startsWith("https://");
    }

    protected boolean isOnRejectList(String candidate) {
        if (this.hasScheme(candidate)) {
            return false;
        }
        if (this.rejectRelativeIgnoreSet.contains(candidate)) {
            return true;
        }
        for (Pattern p : this.rejectRelativeMatchingRegexListPatterns) {
            if (!p.matcher(candidate).matches()) continue;
            return true;
        }
        return false;
    }
}

