/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.extractor;

import org.archive.modules.CrawlURI;
import org.archive.modules.extractor.Extractor;

public abstract class ContentExtractor
extends Extractor {
    @Override
    protected final void extract(CrawlURI uri) {
        boolean finished = this.innerExtract(uri);
        if (finished) {
            uri.linkExtractorFinished();
        }
    }

    @Override
    protected final boolean shouldProcess(CrawlURI uri) {
        if (!uri.isSuccess()) {
            return false;
        }
        if (!this.getExtractorParameters().getExtractIndependently() && uri.hasBeenLinkExtracted()) {
            return false;
        }
        if (uri.getContentLength() <= 0L) {
            return false;
        }
        if (!this.getExtractorParameters().getExtract404s() && uri.getFetchStatus() == 404) {
            return false;
        }
        return this.shouldExtract(uri);
    }

    protected abstract boolean shouldExtract(CrawlURI var1);

    protected abstract boolean innerExtract(CrawlURI var1);
}

