/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.extractor;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.archive.modules.CrawlURI;
import org.archive.modules.ProcessorTestBase;
import org.archive.modules.extractor.Extractor;
import org.archive.modules.extractor.LinkContext;
import org.archive.net.UURI;
import org.archive.net.UURIFactory;
import org.archive.util.Recorder;

public abstract class ContentExtractorTestBase
extends ProcessorTestBase {
    protected Extractor extractor;

    public final void setUp() {
        this.extractor = this.makeExtractor();
    }

    @Override
    protected Object makeModule() {
        return this.makeExtractor();
    }

    protected abstract Extractor makeExtractor();

    protected CrawlURI defaultURI() throws Exception {
        UURI uuri = UURIFactory.getInstance((String)"http://www.archive.org/start/");
        return new CrawlURI(uuri, null, null, LinkContext.NAVLINK_MISC);
    }

    public void testZeroContent() throws Exception {
        CrawlURI uri = this.defaultURI();
        Recorder recorder = ContentExtractorTestBase.createRecorder("");
        uri.setContentType("text/plain");
        uri.setRecorder(recorder);
        this.extractor.process(uri);
        ContentExtractorTestBase.assertEquals((int)0, (int)uri.getOutLinks().size());
        ContentExtractorTestBase.assertNoSideEffects(uri);
    }

    public void testFinished() throws Exception {
        CrawlURI uri = this.defaultURI();
        uri.linkExtractorFinished();
        this.extractor.process(uri);
        ContentExtractorTestBase.assertEquals((int)0, (int)uri.getOutLinks().size());
        ContentExtractorTestBase.assertNoSideEffects(uri);
    }

    protected static void assertNoSideEffects(CrawlURI uri) {
        ContentExtractorTestBase.assertEquals((int)0, (int)uri.getNonFatalFailures().size());
        ContentExtractorTestBase.assertTrue((boolean)uri.getAnnotations().isEmpty());
    }

    @Deprecated
    public static Recorder createRecorder(String content) throws IOException {
        return ContentExtractorTestBase.createRecorder(content, Charset.defaultCharset().name());
    }

    public static Recorder createRecorder(String content, String charset) throws IOException {
        File temp = File.createTempFile("test", ".tmp");
        Recorder recorder = new Recorder(temp, 1024, 1024);
        byte[] b = content.getBytes(charset);
        ByteArrayInputStream bais = new ByteArrayInputStream(b);
        InputStream is = recorder.inputWrap((InputStream)bais);
        recorder.markContentBegin();
        int x = is.read();
        while (x >= 0) {
            x = is.read();
        }
        is.close();
        return recorder;
    }
}

