/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.extractor;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.apache.commons.httpclient.URIException;
import org.archive.io.ReplayCharSequence;
import org.archive.modules.CrawlURI;
import org.archive.modules.extractor.ContentExtractor;
import org.archive.modules.extractor.Extractor;
import org.archive.modules.extractor.Hop;
import org.archive.modules.extractor.LinkContext;
import org.archive.util.DevUtils;
import org.archive.util.TextUtils;

public class ExtractorCSS
extends ContentExtractor {
    private static final long serialVersionUID = 2L;
    private static Logger logger = Logger.getLogger("org.archive.crawler.extractor.ExtractorCSS");
    private static String ESCAPED_AMP = "&amp";
    protected static final String CSS_BACKSLASH_ESCAPE = "\\\\([,'\"\\(\\)\\s])";
    protected static final String CSS_URI_EXTRACTOR = "(?i)(?:@import (?:url[(]|)|url[(])\\s*([\\\"']?)([^\\\"'].{0,2083}?)\\1\\s*[);]";

    @Override
    protected boolean shouldExtract(CrawlURI curi) {
        String mimeType = curi.getContentType();
        if (mimeType == null) {
            return false;
        }
        return mimeType.toLowerCase().indexOf("css") >= 0 || curi.toString().toLowerCase().endsWith(".css");
    }

    @Override
    public boolean innerExtract(CrawlURI curi) {
        try {
            ReplayCharSequence cs = curi.getRecorder().getContentReplayCharSequence();
            this.numberOfLinksExtracted.addAndGet(ExtractorCSS.processStyleCode(this, curi, (CharSequence)cs));
            return true;
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Problem with ReplayCharSequence: " + e.getMessage(), e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long processStyleCode(Extractor ext, CrawlURI curi, CharSequence cs) {
        long foundLinks = 0L;
        Matcher uris = null;
        try {
            uris = TextUtils.getMatcher((String)CSS_URI_EXTRACTOR, (CharSequence)cs);
            while (uris.find()) {
                String cssUri = uris.group(2);
                cssUri = TextUtils.replaceAll((String)ESCAPED_AMP, (CharSequence)cssUri, (String)"&");
                cssUri = TextUtils.replaceAll((String)CSS_BACKSLASH_ESCAPE, (CharSequence)cssUri, (String)"$1");
                ++foundLinks;
                int max = ext.getExtractorParameters().getMaxOutlinks();
                try {
                    ExtractorCSS.addRelativeToBase(curi, max, cssUri, LinkContext.EMBED_MISC, Hop.EMBED);
                }
                catch (URIException e) {
                    ext.logUriError(e, curi.getUURI(), cssUri);
                }
            }
        }
        catch (StackOverflowError e) {
            DevUtils.warnHandle((Throwable)e, (String)"ExtractorCSS StackOverflowError");
        }
        finally {
            TextUtils.recycleMatcher((Matcher)uris);
        }
        return foundLinks;
    }
}

