/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.extractor;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.URIException;
import org.archive.modules.CrawlURI;
import org.archive.modules.extractor.Extractor;
import org.archive.modules.extractor.HTMLLinkContext;
import org.archive.modules.extractor.Hop;
import org.archive.modules.extractor.LinkContext;
import org.archive.net.UURI;
import org.archive.net.UURIFactory;

public class ExtractorHTTP
extends Extractor {
    private static final long serialVersionUID = 3L;
    protected boolean inferRootPage = false;

    public ExtractorHTTP() {
        this.setInferPaths(new ArrayList<String>());
    }

    public boolean getInferRootPage() {
        return this.inferRootPage;
    }

    public void setInferRootPage(boolean inferRootPage) {
        this.inferRootPage = inferRootPage;
    }

    public List<String> getInferPaths() {
        return (List)this.kp.get("inferPaths");
    }

    public void setInferPaths(List<String> inferPaths) {
        this.kp.put((Object)"inferPaths", inferPaths);
    }

    @Override
    protected boolean shouldProcess(CrawlURI uri) {
        if (uri.getFetchStatus() <= 0) {
            return false;
        }
        CrawlURI.FetchType ft = uri.getFetchType();
        return ft == CrawlURI.FetchType.HTTP_GET || ft == CrawlURI.FetchType.HTTP_POST;
    }

    @Override
    protected void extract(CrawlURI curi) {
        this.addHeaderLink(curi, "Location");
        this.addContentLocationHeaderLink(curi, "Content-Location");
        this.addRefreshHeaderLink(curi, "Refresh");
        this.addOutlink(curi, "/favicon.ico", LinkContext.INFERRED_MISC, Hop.INFERRED);
        if (this.getInferRootPage()) {
            this.addOutlink(curi, "/", LinkContext.INFERRED_MISC, Hop.INFERRED);
        }
        for (String inferPath : this.getInferPaths()) {
            this.addOutlink(curi, inferPath, LinkContext.INFERRED_MISC, Hop.INFERRED);
        }
    }

    protected void addRefreshHeaderLink(CrawlURI curi, String headerKey) {
        int urlIndex;
        String headerValue = curi.getHttpResponseHeader(headerKey);
        if (headerValue != null && (urlIndex = headerValue.indexOf("=") + 1) > 0) {
            String refreshUri = headerValue.substring(urlIndex);
            this.addHeaderLink(curi, headerKey, refreshUri);
        }
    }

    protected void addHeaderLink(CrawlURI curi, String headerKey) {
        String headerValue = curi.getHttpResponseHeader(headerKey);
        if (headerValue != null) {
            this.addHeaderLink(curi, headerKey, headerValue);
        }
    }

    protected void addContentLocationHeaderLink(CrawlURI curi, String headerKey) {
        String headerValue = curi.getHttpResponseHeader(headerKey);
        if (headerValue != null) {
            try {
                UURI dest = UURIFactory.getInstance((UURI)curi.getUURI(), (String)headerValue);
                this.addOutlink(curi, dest.toString(), LinkContext.INFERRED_MISC, Hop.INFERRED);
                this.numberOfLinksExtracted.incrementAndGet();
            }
            catch (URIException e) {
                this.logUriError(e, curi.getUURI(), headerValue);
            }
        }
    }

    protected void addHeaderLink(CrawlURI curi, String headerName, String url) {
        try {
            UURI dest = UURIFactory.getInstance((UURI)curi.getUURI(), (String)url);
            HTMLLinkContext lc = HTMLLinkContext.get(headerName + ":");
            this.addOutlink(curi, dest.toString(), (LinkContext)lc, Hop.REFER);
            this.numberOfLinksExtracted.incrementAndGet();
        }
        catch (URIException e) {
            this.logUriError(e, curi.getUURI(), url);
        }
    }
}

