/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.extractor;

import groovy.text.SimpleTemplateEngine;
import groovy.text.Template;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import org.apache.commons.httpclient.URIException;
import org.archive.io.ReplayCharSequence;
import org.archive.modules.CrawlURI;
import org.archive.modules.extractor.Extractor;
import org.archive.modules.extractor.HTMLLinkContext;
import org.archive.modules.extractor.Hop;
import org.archive.util.TextUtils;

public class ExtractorMultipleRegex
extends Extractor {
    private static final Logger LOGGER = Logger.getLogger(ExtractorMultipleRegex.class.getName());
    protected ConcurrentHashMap<String, Template> groovyTemplates;

    public ExtractorMultipleRegex() {
        this.setUriRegex("");
        this.setContentRegexes(new LinkedHashMap<String, String>());
        this.setTemplate("");
        this.groovyTemplates = new ConcurrentHashMap();
    }

    public void setUriRegex(String uriRegex) {
        this.kp.put((Object)"uriRegex", (Object)uriRegex);
    }

    public String getUriRegex() {
        return (String)this.kp.get("uriRegex");
    }

    public void setContentRegexes(Map<String, String> contentRegexes) {
        this.kp.put((Object)"contentRegexes", contentRegexes);
    }

    public Map<String, String> getContentRegexes() {
        return (Map)this.kp.get("contentRegexes");
    }

    public void setTemplate(String template) {
        this.kp.put((Object)"template", (Object)template);
    }

    public String getTemplate() {
        return (String)this.kp.get("template");
    }

    protected Template groovyTemplate() {
        Template groovyTemplate = this.groovyTemplates.get(this.getTemplate());
        if (groovyTemplate == null) {
            try {
                groovyTemplate = new SimpleTemplateEngine().createTemplate(this.getTemplate());
                this.groovyTemplates.put(this.getTemplate(), groovyTemplate);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "problem with groovy template " + this.getTemplate(), e);
            }
        }
        return groovyTemplate;
    }

    @Override
    protected boolean shouldProcess(CrawlURI uri) {
        if (uri.getContentLength() <= 0L) {
            return false;
        }
        return this.getExtractorParameters().getExtract404s() || uri.getFetchStatus() != 404;
    }

    @Override
    public void extract(CrawlURI curi) {
        ReplayCharSequence cs;
        Matcher matcher = TextUtils.getMatcher((String)this.getUriRegex(), (CharSequence)curi.getURI());
        if (!matcher.matches()) {
            TextUtils.recycleMatcher((Matcher)matcher);
            return;
        }
        LinkedHashMap<String, MatchList> matchLists = new LinkedHashMap<String, MatchList>();
        matchLists.put("uriRegex", new MatchList(new GroupList(matcher)));
        try {
            cs = curi.getRecorder().getContentReplayCharSequence();
        }
        catch (IOException e) {
            curi.getNonFatalFailures().add(e);
            LOGGER.log(Level.WARNING, "Failed get of replay char sequence in " + Thread.currentThread().getName(), e);
            TextUtils.recycleMatcher((Matcher)matcher);
            return;
        }
        for (String string : this.getContentRegexes().keySet()) {
            String regex = this.getContentRegexes().get(string);
            MatchList matchList = new MatchList(regex, (CharSequence)cs);
            if (matchList.isEmpty()) {
                TextUtils.recycleMatcher((Matcher)matcher);
                return;
            }
            matchLists.put(string, matchList);
        }
        int numOutlinks = 1;
        for (MatchList matchList : matchLists.values()) {
            numOutlinks *= matchList.size();
        }
        String[] stringArray = matchLists.keySet().toArray(new String[0]);
        for (int i = 0; i < numOutlinks; ++i) {
            Map<String, Object> bindings = this.makeBindings(matchLists, stringArray, i);
            this.buildAndAddOutlink(curi, bindings);
        }
        TextUtils.recycleMatcher((Matcher)matcher);
    }

    protected Map<String, Object> makeBindings(Map<String, MatchList> matchLists, String[] regexNames, int outlinkIndex) {
        LinkedHashMap<String, Object> bindings = new LinkedHashMap<String, Object>();
        int tmp = outlinkIndex;
        for (int regexIndex = 0; regexIndex < regexNames.length; ++regexIndex) {
            MatchList matchList = matchLists.get(regexNames[regexIndex]);
            int matchIndex = tmp % matchList.size();
            bindings.put(regexNames[regexIndex], matchList.get(matchIndex));
            tmp /= matchList.size();
        }
        return bindings;
    }

    protected void buildAndAddOutlink(CrawlURI curi, Map<String, Object> bindings) {
        String outlinkUri = this.groovyTemplate().make(bindings).toString();
        try {
            ExtractorMultipleRegex.addRelativeToBase(curi, this.getExtractorParameters().getMaxOutlinks(), outlinkUri, HTMLLinkContext.INFERRED_MISC, Hop.INFERRED);
        }
        catch (URIException e) {
            this.logUriError(e, curi.getUURI(), outlinkUri);
        }
    }

    protected class GroupList
    extends LinkedList<String> {
        private static final long serialVersionUID = 1L;

        public GroupList(MatchResult matchResult) {
            for (int i = 0; i <= matchResult.groupCount(); ++i) {
                this.add(matchResult.group(i));
            }
        }
    }

    protected class MatchList
    extends LinkedList<GroupList> {
        private static final long serialVersionUID = 1L;

        public MatchList(String regex, CharSequence cs) {
            Matcher matcher = TextUtils.getMatcher((String)regex, (CharSequence)cs);
            while (matcher.find()) {
                this.add(new GroupList(matcher));
            }
            TextUtils.recycleMatcher((Matcher)matcher);
        }

        public MatchList(GroupList ... groupList) {
            for (GroupList x : groupList) {
                this.add(x);
            }
        }
    }
}

