/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.extractor;

import com.anotherbigidea.flash.interfaces.SWFActions;
import com.anotherbigidea.flash.interfaces.SWFTagTypes;
import com.anotherbigidea.flash.interfaces.SWFTags;
import com.anotherbigidea.flash.readers.ActionParser;
import com.anotherbigidea.flash.readers.SWFReader;
import com.anotherbigidea.flash.readers.TagParser;
import com.anotherbigidea.flash.structs.AlphaTransform;
import com.anotherbigidea.flash.structs.Matrix;
import com.anotherbigidea.flash.writers.SWFActionsImpl;
import com.anotherbigidea.io.InStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import org.archive.modules.CrawlURI;
import org.archive.modules.extractor.ContentExtractor;
import org.archive.modules.extractor.CustomSWFTags;
import org.archive.modules.extractor.Extractor;
import org.archive.modules.extractor.ExtractorJS;
import org.archive.modules.extractor.Hop;
import org.archive.modules.extractor.LinkContext;
import org.archive.util.UriUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ExtractorSWF
extends ContentExtractor {
    private static final long serialVersionUID = 3L;
    private static Logger logger = Logger.getLogger(ExtractorSWF.class.getName());
    private static final int MAX_READ_SIZE = 0x100000;
    protected static final String JSSTRING = "javascript:";
    protected transient ExtractorJS extractorJS;

    public ExtractorJS getExtractorJS() {
        return this.extractorJS;
    }

    @Autowired
    public void setExtractorJS(ExtractorJS extractorJS) {
        this.extractorJS = extractorJS;
    }

    @Override
    protected boolean shouldExtract(CrawlURI uri) {
        String contentType = uri.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().indexOf("x-shockwave-flash") >= 0 || uri.toString().toLowerCase().endsWith(".swf");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean innerExtract(CrawlURI curi) {
        InputStream documentStream = null;
        try {
            documentStream = curi.getRecorder().getContentReplayInputStream();
            if (documentStream == null) {
                boolean bl = false;
                return bl;
            }
            CrawlUriSWFAction curiAction = new CrawlUriSWFAction(curi, this);
            CustomSWFTags customTags = new CustomSWFTags((SWFActions)curiAction);
            ExtractorSWFReader reader = new ExtractorSWFReader((SWFTags)new ExtractorTagParser((SWFTagTypes)customTags), documentStream);
            reader.readFile();
            this.numberOfLinksExtracted.addAndGet(curiAction.getLinkCount());
            logger.fine(curi + " has " + curiAction.getLinkCount() + " links.");
        }
        catch (IOException e) {
            curi.getNonFatalFailures().add(e);
        }
        finally {
            try {
                documentStream.close();
            }
            catch (IOException e) {
                curi.getNonFatalFailures().add(e);
            }
        }
        return true;
    }

    public class CrawlUriSWFAction
    extends SWFActionsImpl {
        protected CrawlURI curi;
        private long linkCount;
        private Extractor ext;

        public CrawlUriSWFAction(CrawlURI curi, Extractor ext) {
            assert (curi != null) : "CrawlURI should not be null";
            this.curi = curi;
            this.linkCount = 0L;
            this.ext = ext;
        }

        public void getURL(String url, String target) throws IOException {
            if (url.startsWith(ExtractorSWF.JSSTRING)) {
                if (ExtractorSWF.this.getExtractorJS() != null) {
                    this.linkCount += ExtractorSWF.this.getExtractorJS().considerStrings(this.ext, this.curi, url);
                }
            } else {
                int max = this.ext.getExtractorParameters().getMaxOutlinks();
                CrawlURI relToVia = Extractor.addRelativeToVia(this.curi, max, url, LinkContext.EMBED_MISC, Hop.EMBED);
                CrawlURI relToBase = Extractor.addRelativeToBase(this.curi, max, url, LinkContext.EMBED_MISC, Hop.EMBED);
                this.addAnnotations(relToVia, relToBase);
                ++this.linkCount;
            }
        }

        protected void addAnnotations(CrawlURI relToVia, CrawlURI relToBase) {
            if (relToVia != null && relToBase != null && relToVia.getUURI().equals((Object)relToBase.getUURI())) {
                relToVia.getAnnotations().add("extractorSWFRelToBoth");
                relToBase.getAnnotations().add("extractorSWFRelToBoth");
            } else {
                if (relToVia != null) {
                    relToVia.getAnnotations().add("extractorSWFRelToVia");
                }
                if (relToBase != null) {
                    relToBase.getAnnotations().add("extractorSWFRelToBase");
                }
            }
        }

        public void considerStringAsUri(String str) throws IOException {
            if (UriUtils.isVeryLikelyUri((CharSequence)str)) {
                int max = this.ext.getExtractorParameters().getMaxOutlinks();
                CrawlURI relToVia = Extractor.addRelativeToVia(this.curi, max, str, LinkContext.SPECULATIVE_MISC, Hop.SPECULATIVE);
                CrawlURI relToBase = Extractor.addRelativeToBase(this.curi, max, str, LinkContext.SPECULATIVE_MISC, Hop.SPECULATIVE);
                this.addAnnotations(relToVia, relToBase);
                ++this.linkCount;
            }
        }

        public void lookupTable(String[] strings) throws IOException {
            for (String str : strings) {
                this.considerStringAsUri(str);
            }
        }

        public void push(String value) throws IOException {
            this.considerStringAsUri(value);
        }

        public long getLinkCount() {
            return this.linkCount;
        }
    }

    protected class ExtractorTagParser
    extends TagParser {
        protected ExtractorTagParser(SWFTagTypes tagtypes) {
            super(tagtypes);
        }

        protected void parseDefineBits(InStream in) throws IOException {
        }

        protected void parseDefineBitsJPEG3(InStream in) throws IOException {
        }

        protected void parseDefineBitsLossless(InStream in, int length, boolean hasAlpha) throws IOException {
        }

        protected void parseDefineButtonSound(InStream in) throws IOException {
        }

        protected void parseDefineFont(InStream in) throws IOException {
        }

        protected void parseDefineJPEG2(InStream in, int length) throws IOException {
        }

        protected void parseDefineJPEGTables(InStream in) throws IOException {
        }

        protected void parseDefineShape(int type, InStream in) throws IOException {
        }

        protected void parseDefineSound(InStream in) throws IOException {
        }

        protected void parseFontInfo(InStream in, int length, boolean isFI2) throws IOException {
        }

        protected void parseDefineFont2(InStream in) throws IOException {
        }

        protected void parseDefineSprite(InStream in) throws IOException {
            int id = in.readUI16();
            in.readUI16();
            SWFTagTypes sstt = this.mTagtypes.tagDefineSprite(id);
            if (sstt == null) {
                return;
            }
            ExtractorTagParser parser = new ExtractorTagParser(sstt);
            SWFReader reader = new SWFReader((SWFTags)parser, in);
            reader.readTags();
        }

        protected void parsePlaceObject2(InStream in) throws IOException {
            boolean hasClipActions = in.readUBits(1) != 0L;
            boolean hasClipDepth = in.readUBits(1) != 0L;
            boolean hasName = in.readUBits(1) != 0L;
            boolean hasRatio = in.readUBits(1) != 0L;
            boolean hasColorTransform = in.readUBits(1) != 0L;
            boolean hasMatrix = in.readUBits(1) != 0L;
            boolean hasCharacter = in.readUBits(1) != 0L;
            boolean isMove = in.readUBits(1) != 0L;
            int depth = in.readUI16();
            int charId = hasCharacter ? in.readUI16() : 0;
            Matrix matrix = hasMatrix ? new Matrix(in) : null;
            AlphaTransform cxform = hasColorTransform ? new AlphaTransform(in) : null;
            int ratio = hasRatio ? in.readUI16() : -1;
            String name = hasName ? in.readString(this.mStringEncoding) : null;
            int clipDepth = hasClipDepth ? in.readUI16() : 0;
            int clipEventFlags = 0;
            if (hasClipActions) {
                in.readUI16();
                clipEventFlags = this.mFlashVersion < 6 ? in.readUI16() : in.readSI32();
            }
            SWFActions actions = this.mTagtypes.tagPlaceObject2(isMove, clipDepth, depth, charId, matrix, cxform, ratio, name, clipEventFlags);
            if (hasClipActions && actions != null) {
                int flags = 0;
                while ((flags = this.mFlashVersion < 6 ? in.readUI16() : in.readSI32()) != 0) {
                    in.readUI32();
                    actions.start(flags);
                    ActionParser parser = new ActionParser(actions, this.mFlashVersion);
                    parser.parse(in);
                }
                actions.done();
            }
        }
    }

    class ExtractorSWFReader
    extends SWFReader {
        public ExtractorSWFReader(SWFTags consumer, InputStream inputstream) {
            super(consumer, inputstream);
        }

        public ExtractorSWFReader(SWFTags consumer, InStream instream) {
            super(consumer, instream);
        }

        public int readOneTag() throws IOException {
            boolean longTag;
            int header = this.mIn.readUI16();
            int type = header >> 6;
            int length = header & 0x3F;
            boolean bl = longTag = length == 63;
            if (longTag) {
                length = (int)this.mIn.readUI32();
            }
            if (length > 0x100000) {
                this.mIn.skipBytes((long)length);
                logger.info("oversized SWF tag (type=" + type + ";length=" + length + ") skipped");
            } else {
                byte[] contents = this.mIn.read(length);
                this.mConsumer.tag(type, longTag, contents);
            }
            return type;
        }
    }
}

