/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.extractor;

import org.archive.modules.extractor.LinkContext;

public class HTMLLinkContext
extends LinkContext {
    private static final long serialVersionUID = 1L;
    public static final HTMLLinkContext META = new HTMLLinkContext("meta");
    public static final HTMLLinkContext A_HREF = new HTMLLinkContext("a", "href");
    public static final HTMLLinkContext IMG_SRC = new HTMLLinkContext("img", "src");
    public static final HTMLLinkContext IMG_SRCSET = new HTMLLinkContext("img", "srcset");
    public static final HTMLLinkContext SOURCE_SRCSET = new HTMLLinkContext("source", "srcset");
    public static final HTMLLinkContext IMG_DATA_SRC = new HTMLLinkContext("img", "data-src");
    public static final HTMLLinkContext IMG_DATA_SRC_SMALL = new HTMLLinkContext("img", "data-src-small");
    public static final HTMLLinkContext IMG_DATA_SRC_MEDIUM = new HTMLLinkContext("img", "data-src-medium");
    public static final HTMLLinkContext IMG_DATA_SRCSET = new HTMLLinkContext("img", "data-srcset");
    public static final HTMLLinkContext SOURCE_DATA_SRCSET = new HTMLLinkContext("source", "data-srcset");
    public static final HTMLLinkContext IMG_DATA_ORIGINAL = new HTMLLinkContext("img", "data-original");
    public static final HTMLLinkContext IMG_DATA_ORIGINAL_SET = new HTMLLinkContext("img", "data-original-set");
    public static final HTMLLinkContext SOURCE_DATA_ORIGINAL_SET = new HTMLLinkContext("source", "data-original-set");
    public static final HTMLLinkContext IMG_DATA_LAZY = new HTMLLinkContext("img", "data-lazy");
    public static final HTMLLinkContext IMG_DATA_LAZY_SRCSET = new HTMLLinkContext("img", "data-lazy-srcset");
    public static final HTMLLinkContext SOURCE_DATA_LAZY_SRCSET = new HTMLLinkContext("source", "data-lazy-srcset");
    public static final HTMLLinkContext IMG_DATA_FULL_SRC = new HTMLLinkContext("img", "data-full-src");
    public static final HTMLLinkContext SCRIPT_SRC = new HTMLLinkContext("script", "src");
    public static final HTMLLinkContext META_HREF = new HTMLLinkContext("meta", "href");
    public static final HTMLLinkContext LINK_IMAGESRCSET = new HTMLLinkContext("link", "imagesrcset");
    private final String path;

    public static HTMLLinkContext get(CharSequence el, CharSequence attr) {
        switch (attr.toString().toLowerCase()) {
            case "href": {
                if (el.toString().equalsIgnoreCase("a")) {
                    return A_HREF;
                }
                if (!el.toString().equalsIgnoreCase("meta")) break;
                return META_HREF;
            }
            case "src": {
                if (el.toString().equalsIgnoreCase("img")) {
                    return IMG_SRC;
                }
                if (!el.toString().equalsIgnoreCase("script")) break;
                return SCRIPT_SRC;
            }
            case "srcset": {
                if (el.toString().equalsIgnoreCase("img")) {
                    return IMG_SRCSET;
                }
                if (!el.toString().equalsIgnoreCase("source")) break;
                return SOURCE_SRCSET;
            }
            case "data-src": {
                if (!el.toString().equalsIgnoreCase("img")) break;
                return IMG_DATA_SRC;
            }
            case "data-srcset": {
                if (el.toString().equalsIgnoreCase("img")) {
                    return IMG_DATA_SRCSET;
                }
                if (!el.toString().equalsIgnoreCase("source")) break;
                return SOURCE_DATA_SRCSET;
            }
            case "data-original": {
                if (!el.toString().equalsIgnoreCase("img")) break;
                return IMG_DATA_ORIGINAL;
            }
            case "data-original-set": {
                if (el.toString().equalsIgnoreCase("img")) {
                    return IMG_DATA_ORIGINAL_SET;
                }
                if (!el.toString().equalsIgnoreCase("source")) break;
                return SOURCE_DATA_ORIGINAL_SET;
            }
            case "data-full-src": {
                if (!el.toString().equalsIgnoreCase("img")) break;
                return IMG_DATA_FULL_SRC;
            }
            case "data-lazy-srcset": {
                if (el.toString().equalsIgnoreCase("img")) {
                    return IMG_DATA_LAZY_SRCSET;
                }
                if (!el.toString().equalsIgnoreCase("source")) break;
                return SOURCE_DATA_LAZY_SRCSET;
            }
            case "data-lazy": {
                if (!el.toString().equalsIgnoreCase("img")) break;
                return IMG_DATA_LAZY;
            }
            case "data-src-small": {
                if (!el.toString().equalsIgnoreCase("img")) break;
                return IMG_DATA_SRC_SMALL;
            }
            case "data-src-medium": {
                if (!el.toString().equalsIgnoreCase("img")) break;
                return IMG_DATA_SRC_MEDIUM;
            }
            case "imagesrcset": {
                if (!el.toString().equalsIgnoreCase("link")) break;
                return LINK_IMAGESRCSET;
            }
            default: {
                return new HTMLLinkContext(el, attr);
            }
        }
        return new HTMLLinkContext(el, attr);
    }

    public static HTMLLinkContext get(String path) {
        if (path.equalsIgnoreCase("a/@href")) {
            return A_HREF;
        }
        if (path.equalsIgnoreCase("meta/@href")) {
            return META_HREF;
        }
        if (path.equalsIgnoreCase("img/@src")) {
            return IMG_SRC;
        }
        if (path.equalsIgnoreCase("img/@srcset")) {
            return IMG_SRCSET;
        }
        if (path.equalsIgnoreCase("source/@srcset")) {
            return SOURCE_SRCSET;
        }
        if (path.equalsIgnoreCase("script/@src")) {
            return SCRIPT_SRC;
        }
        if (path.equalsIgnoreCase("img/@data-src")) {
            return IMG_DATA_SRC;
        }
        if (path.equalsIgnoreCase("img/@data-src-small")) {
            return IMG_DATA_SRC_SMALL;
        }
        if (path.equalsIgnoreCase("img/@data-src-medium")) {
            return IMG_DATA_SRC_MEDIUM;
        }
        if (path.equalsIgnoreCase("img/@data-srcset")) {
            return IMG_DATA_SRCSET;
        }
        if (path.equalsIgnoreCase("img/@data-original")) {
            return IMG_DATA_ORIGINAL;
        }
        if (path.equalsIgnoreCase("img/@data-full-src")) {
            return IMG_DATA_FULL_SRC;
        }
        if (path.equalsIgnoreCase("img/@data-original-set")) {
            return IMG_DATA_ORIGINAL_SET;
        }
        if (path.equalsIgnoreCase("source/@data-original-set")) {
            return SOURCE_DATA_ORIGINAL_SET;
        }
        if (path.equalsIgnoreCase("img/@data-lazy-srcset")) {
            return IMG_DATA_LAZY_SRCSET;
        }
        if (path.equalsIgnoreCase("source/@data-lazy-srcset")) {
            return SOURCE_DATA_LAZY_SRCSET;
        }
        if (path.equalsIgnoreCase("img/@data-lazy")) {
            return IMG_DATA_LAZY;
        }
        if (path.equalsIgnoreCase("source/@data-srcset")) {
            return SOURCE_DATA_SRCSET;
        }
        if (path.equalsIgnoreCase("link/@imagesrcset")) {
            return LINK_IMAGESRCSET;
        }
        return new HTMLLinkContext(path);
    }

    protected HTMLLinkContext(String path) {
        this.path = path;
    }

    protected HTMLLinkContext(CharSequence element, CharSequence attribute) {
        this.path = attribute == null ? "" : element + "/@" + attribute;
    }

    public String toString() {
        return this.path;
    }
}

