/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.extractor;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionURI;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;

public class PDFParser
implements Closeable {
    protected ArrayList<String> foundURIs;
    protected PDDocument documentReader;
    protected byte[] document;

    public PDFParser(String doc) throws IOException {
        this.resetState();
        this.getInFromFile(doc);
        this.initialize();
    }

    public PDFParser(byte[] doc) throws IOException {
        this.resetState();
        this.document = doc;
        this.initialize();
    }

    protected void resetState() {
        this.foundURIs = new ArrayList();
        this.documentReader = null;
        this.document = null;
    }

    public void resetState(byte[] doc) throws IOException {
        this.resetState();
        this.document = doc;
        this.initialize();
    }

    public void resetState(String doc) throws IOException {
        this.resetState();
        this.getInFromFile(doc);
        this.initialize();
    }

    protected void getInFromFile(String doc) throws IOException {
        File documentOnDisk = new File(doc);
        this.documentReader = Loader.loadPDF((File)documentOnDisk);
    }

    public ArrayList<String> getURIs() {
        return this.foundURIs;
    }

    protected void initialize() throws IOException {
        if (this.document != null) {
            this.documentReader = Loader.loadPDF((byte[])this.document);
        }
    }

    public ArrayList<String> extractURIs() throws IOException {
        for (PDPage page : this.documentReader.getPages()) {
            for (PDAnnotation annotation : page.getAnnotations()) {
                PDAnnotationLink link;
                PDAction action;
                if (!(annotation instanceof PDAnnotationLink) || !((action = (link = (PDAnnotationLink)annotation).getAction()) instanceof PDActionURI)) continue;
                PDActionURI uri = (PDActionURI)action;
                this.foundURIs.add(uri.getURI());
            }
        }
        return this.getURIs();
    }

    @Override
    public void close() throws IOException {
        if (this.documentReader != null) {
            this.documentReader.close();
        }
    }

    public static void main(String[] argv) {
        try {
            PDFParser parser = new PDFParser("/tmp/pdfspec.pdf");
            ArrayList<String> uris = parser.extractURIs();
            for (String uri : uris) {
                System.out.println("got uri: " + uri);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

