/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.extractor;

import java.util.Collection;
import java.util.HashSet;
import org.archive.modules.CrawlURI;
import org.archive.modules.extractor.ContentExtractorTestBase;

public abstract class StringExtractorTestBase
extends ContentExtractorTestBase {
    protected abstract String[] getValidTestData();

    protected abstract Collection<TestData> makeData(String var1, String var2) throws Exception;

    public void testExtraction() throws Exception {
        try {
            String[] valid = this.getValidTestData();
            for (int i = 0; i < valid.length; i += 2) {
                this.testOne(valid[i], valid[i + 1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void testOne(String text, String expectedURL) throws Exception {
        Collection<TestData> testDataCol = this.makeData(text, expectedURL);
        for (TestData testData : testDataCol) {
            testData.uri.setFetchStatus(200);
            this.extractor.process(testData.uri);
            HashSet<CrawlURI> expected = new HashSet<CrawlURI>();
            if (testData.expectedResult != null) {
                expected.add(testData.expectedResult);
            }
            StringExtractorTestBase.assertEquals(expected, testData.uri.getOutLinks());
            StringExtractorTestBase.assertNoSideEffects(testData.uri);
        }
    }

    public static class TestData {
        public CrawlURI uri;
        public CrawlURI expectedResult;

        public TestData(CrawlURI uri, CrawlURI expectedResult) {
            this.uri = uri;
            this.expectedResult = expectedResult;
        }
    }
}

