/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.extractor;

import org.archive.modules.CrawlURI;
import org.archive.modules.extractor.ContentExtractor;

public class TrapSuppressExtractor
extends ContentExtractor {
    private static final long serialVersionUID = -1028783453022579530L;
    public static String A_VIA_DIGEST = "via-digest";
    protected long numberOfCURIsHandled = 0L;
    protected long numberOfCURIsSuppressed = 0L;

    @Override
    protected boolean shouldExtract(CrawlURI uri) {
        return true;
    }

    @Override
    protected boolean innerExtract(CrawlURI curi) {
        ++this.numberOfCURIsHandled;
        String currentDigest = curi.getContentDigestSchemeString();
        String viaDigest = null;
        if (curi.containsDataKey(A_VIA_DIGEST)) {
            viaDigest = (String)curi.getData().get(A_VIA_DIGEST);
        }
        if (currentDigest != null) {
            curi.makeHeritable(A_VIA_DIGEST);
            if (currentDigest.equals(viaDigest)) {
                curi.getAnnotations().add("trapSuppressExtractor");
                ++this.numberOfCURIsSuppressed;
                return true;
            }
            curi.getData().put(A_VIA_DIGEST, currentDigest);
        }
        return false;
    }
}

