/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.fetcher;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.CookieStore;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieIdentityComparator;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.archive.checkpointing.Checkpointable;
import org.archive.modules.CrawlURI;
import org.archive.modules.fetcher.FetchHTTPCookieStore;
import org.archive.spring.ConfigFile;
import org.archive.spring.ConfigPath;
import org.springframework.context.Lifecycle;

public abstract class AbstractCookieStore
implements Lifecycle,
Checkpointable,
CookieStore,
FetchHTTPCookieStore {
    public static final int MAX_COOKIES_FOR_DOMAIN = 50;
    protected final Logger logger = Logger.getLogger(AbstractCookieStore.class.getName());
    protected static final Comparator<Cookie> cookieComparator = new CookieIdentityComparator();
    protected ConfigFile cookiesLoadFile = null;
    protected ConfigPath cookiesSaveFile = null;
    protected boolean isRunning = false;

    public ConfigFile getCookiesLoadFile() {
        return this.cookiesLoadFile;
    }

    public void setCookiesLoadFile(ConfigFile cookiesLoadFile) {
        this.cookiesLoadFile = cookiesLoadFile;
    }

    public ConfigPath getCookiesSaveFile() {
        return this.cookiesSaveFile;
    }

    public void setCookiesSaveFile(ConfigPath cookiesSaveFile) {
        this.cookiesSaveFile = cookiesSaveFile;
    }

    public void start() {
        if (this.isRunning()) {
            return;
        }
        this.prepare();
        if (this.getCookiesLoadFile() != null) {
            this.loadCookies(this.getCookiesLoadFile());
        }
        this.isRunning = true;
    }

    public void stop() {
        this.isRunning = false;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void saveCookies() {
        if (this.getCookiesSaveFile() != null) {
            this.saveCookies(this.getCookiesSaveFile().getFile().getAbsolutePath());
        }
    }

    protected void loadCookies(ConfigFile file) {
        Reader reader = null;
        try {
            reader = file.obtainReader();
            this.loadCookies(reader);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    protected void loadCookies(Reader reader) {
        Collection<Cookie> loadedCookies = this.readCookies(reader);
        for (Cookie cookie : loadedCookies) {
            this.addCookie(cookie);
        }
    }

    public void saveCookies(String saveCookiesFile) {
        if (saveCookiesFile == null || saveCookiesFile.length() <= 0) {
            return;
        }
        try (BufferedWriter out = Files.newBufferedWriter(Paths.get(saveCookiesFile, new String[0]), new OpenOption[0]);){
            String tab = "\t";
            out.write("# Heritrix Cookie File\n");
            out.write("# This file is the Netscape cookies.txt format\n\n");
            for (Cookie cookie : new ArrayList(this.getCookies())) {
                out.write(cookie.getDomain());
                out.write(tab);
                out.write("TRUE");
                out.write(tab);
                out.write(cookie.getPath() != null ? cookie.getPath() : "/");
                out.write(tab);
                out.write(cookie.isSecure() ? "TRUE" : "FALSE");
                out.write(tab);
                out.write(Long.toString(cookie.getExpiryDate() != null ? cookie.getExpiryDate().getTime() / 1000L : -1L));
                out.write(tab);
                out.write(cookie.getName());
                out.write(tab);
                out.write(cookie.getValue() != null ? cookie.getValue() : "");
                out.write("\n");
            }
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Unable to write " + saveCookiesFile, e);
        }
    }

    protected Collection<Cookie> readCookies(Reader reader) {
        LinkedList<Cookie> cookies = new LinkedList<Cookie>();
        BufferedReader br = new BufferedReader(reader);
        try {
            String line;
            int lineNo = 1;
            while ((line = br.readLine()) != null) {
                if (!line.matches("\\s*(?:#.*)?")) {
                    String[] tokens = line.split("\\t");
                    if (tokens.length == 7) {
                        long epochSeconds = Long.parseLong(tokens[4]);
                        Date expirationDate = epochSeconds >= 0L ? new Date(epochSeconds * 1000L) : null;
                        BasicClientCookie cookie = new BasicClientCookie(tokens[5], tokens[6]);
                        cookie.setDomain(tokens[0]);
                        cookie.setExpiryDate(expirationDate);
                        cookie.setSecure(Boolean.valueOf(tokens[3]).booleanValue());
                        cookie.setPath(tokens[2]);
                        this.logger.fine("Adding cookie: domain " + cookie.getDomain() + " cookie " + cookie);
                        cookies.add((Cookie)cookie);
                    } else {
                        this.logger.warning("cookies input line " + lineNo + " invalid, expected 7 tab-delimited tokens");
                    }
                }
                ++lineNo;
            }
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, e.getMessage(), e);
        }
        return cookies;
    }

    protected String sortableKey(Cookie cookie) {
        String normalizedDomain = this.normalizeHost(cookie.getDomain());
        StringBuilder buf = new StringBuilder(normalizedDomain);
        buf.append(";").append(cookie.getName());
        buf.append(";").append(cookie.getPath() != null ? cookie.getPath() : "/");
        return buf.toString();
    }

    protected String normalizeHost(String host) {
        if (host == null) {
            host = "";
        }
        if (host.startsWith(".")) {
            host = host.substring(1);
        }
        host = host.toLowerCase(Locale.ENGLISH);
        return host;
    }

    @Override
    public CookieStore cookieStoreFor(CrawlURI curi) throws URIException {
        String normalizedHost = this.normalizeHost(curi.getUURI().getHost());
        return this.cookieStoreFor(normalizedHost);
    }

    public boolean isCookieCountMaxedForDomain(String domain) {
        CookieStore cookieStore = this.cookieStoreFor(this.normalizeHost(domain));
        return cookieStore != null && cookieStore.getCookies().size() >= 50;
    }

    public void addCookie(Cookie cookie) {
        if (this.isCookieCountMaxedForDomain(cookie.getDomain())) {
            this.logger.log(Level.FINEST, "Maximum number of cookies reached for domain " + cookie.getDomain() + ". Will not add new cookie " + cookie.getName() + " with value " + cookie.getValue());
            return;
        }
        this.addCookieImpl(cookie);
    }

    public abstract boolean expireCookie(Cookie var1, Date var2);

    protected abstract void addCookieImpl(Cookie var1);

    public abstract void clear();

    protected abstract void prepare();

    protected class LimitedCookieStoreFacade
    implements CookieStore {
        private List<Cookie> cookies;

        protected LimitedCookieStoreFacade(List<Cookie> cookies) {
            this.cookies = cookies;
        }

        public List<Cookie> getCookies() {
            return this.cookies;
        }

        public boolean clearExpired(Date date) {
            int expiredCount = 0;
            for (Cookie c : this.cookies) {
                boolean expired = AbstractCookieStore.this.expireCookie(c, date);
                if (!expired) continue;
                AbstractCookieStore.this.logger.fine("Expired cookie: " + c + " for date: " + date);
                ++expiredCount;
            }
            if (expiredCount > 0) {
                AbstractCookieStore.this.logger.fine("Expired " + expiredCount + " cookies for date: " + date);
                return true;
            }
            return false;
        }

        public void clear() {
            throw new RuntimeException("not implemented");
        }

        public void addCookie(Cookie cookie) {
            AbstractCookieStore.this.addCookie(cookie);
        }
    }
}

