/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.fetcher;

import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.client.methods.AbstractExecutionAwareRequest;
import org.apache.http.message.BasicRequestLine;
import org.apache.http.util.Args;

public class BasicExecutionAwareRequest
extends AbstractExecutionAwareRequest {
    private final String method;
    private final String uri;
    private RequestLine requestline;

    public BasicExecutionAwareRequest(String method, String uri) {
        this.method = (String)Args.notNull((Object)method, (String)"Method name");
        this.uri = (String)Args.notNull((Object)uri, (String)"Request URI");
        this.requestline = null;
    }

    public BasicExecutionAwareRequest(String method, String uri, ProtocolVersion ver) {
        this((RequestLine)new BasicRequestLine(method, uri, ver));
    }

    public BasicExecutionAwareRequest(RequestLine requestline) {
        this.requestline = (RequestLine)Args.notNull((Object)requestline, (String)"Request line");
        this.method = requestline.getMethod();
        this.uri = requestline.getUri();
    }

    public ProtocolVersion getProtocolVersion() {
        return this.getRequestLine().getProtocolVersion();
    }

    public RequestLine getRequestLine() {
        if (this.requestline == null) {
            this.requestline = new BasicRequestLine(this.method, this.uri, (ProtocolVersion)HttpVersion.HTTP_1_1);
        }
        return this.requestline;
    }

    public String toString() {
        return this.method + " " + this.uri + " " + this.headergroup;
    }
}

