/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.fetcher;

import com.google.common.net.InternetDomainName;
import com.sleepycat.bind.ByteArrayBinding;
import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.SortedMap;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.collection.CompositeCollection;
import org.apache.http.client.CookieStore;
import org.apache.http.cookie.Cookie;
import org.archive.bdb.BdbModule;
import org.archive.checkpointing.Checkpoint;
import org.archive.modules.fetcher.AbstractCookieStore;
import org.archive.modules.fetcher.FetchHTTPCookieStore;
import org.springframework.beans.factory.annotation.Autowired;

public class BdbCookieStore
extends AbstractCookieStore
implements FetchHTTPCookieStore,
CookieStore {
    protected BdbModule bdb;
    public static String COOKIEDB_NAME = "hc_httpclient_cookies";
    private transient Database cookieDb;
    private transient StoredSortedMap<byte[], Cookie> cookies;
    protected boolean isCheckpointRecovery = false;

    @Autowired
    public void setBdbModule(BdbModule bdb) {
        this.bdb = bdb;
    }

    @Override
    public void prepare() {
        try {
            StoredClassCatalog classCatalog = this.bdb.getClassCatalog();
            BdbModule.BdbConfig dbConfig = new BdbModule.BdbConfig();
            dbConfig.setTransactional(false);
            dbConfig.setAllowCreate(true);
            dbConfig.setSortedDuplicates(false);
            this.cookieDb = this.bdb.openDatabase(COOKIEDB_NAME, dbConfig, this.isCheckpointRecovery);
            this.cookies = new StoredSortedMap(this.cookieDb, (EntryBinding)new ByteArrayBinding(), (EntryBinding)new SerialBinding((ClassCatalog)classCatalog, Cookie.class), true);
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addCookieImpl(Cookie cookie) {
        byte[] key;
        try {
            key = this.sortableKey(cookie).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (!cookie.isExpired(new Date())) {
            this.cookies.put((Object)key, (Object)cookie);
        } else {
            this.cookies.remove((Object)key);
        }
    }

    @Override
    public boolean expireCookie(Cookie cookie, Date date) {
        byte[] key = this.sortableKey(cookie).getBytes(StandardCharsets.UTF_8);
        if (cookie.isExpired(date)) {
            this.cookies.remove((Object)key);
            return true;
        }
        return false;
    }

    protected Collection<Cookie> hostSubset(String host) {
        try {
            byte[] startKey = (host + ";").getBytes("UTF-8");
            char chAfterDelim = '<';
            byte[] endKey = (host + chAfterDelim).getBytes("UTF-8");
            SortedMap submap = this.cookies.subMap((Object)startKey, (Object)endKey);
            return submap.values();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CookieStore cookieStoreFor(String host) {
        CompositeCollection cookieCollection = new CompositeCollection();
        if (InternetDomainName.isValid((String)host)) {
            InternetDomainName domain = InternetDomainName.from((String)host);
            while (domain != null) {
                Collection<Cookie> subset = this.hostSubset(domain.toString());
                cookieCollection.addComposited(subset);
                if (domain.hasParent()) {
                    domain = domain.parent();
                    continue;
                }
                domain = null;
            }
        } else {
            Collection<Cookie> subset = this.hostSubset(host.toString());
            cookieCollection.addComposited(subset);
        }
        RestrictedCollectionWrappedList<Cookie> cookieList = new RestrictedCollectionWrappedList<Cookie>((Collection<Cookie>)cookieCollection);
        AbstractCookieStore.LimitedCookieStoreFacade store = new AbstractCookieStore.LimitedCookieStoreFacade(cookieList);
        return store;
    }

    public void startCheckpoint(Checkpoint checkpointInProgress) {
    }

    public void doCheckpoint(Checkpoint checkpointInProgress) throws IOException {
    }

    public void finishCheckpoint(Checkpoint checkpointInProgress) {
    }

    public void setRecoveryCheckpoint(Checkpoint recoveryCheckpoint) {
        this.isCheckpointRecovery = true;
    }

    @Override
    public void clear() {
        this.cookies.clear();
    }

    public List<Cookie> getCookies() {
        if (this.cookies != null) {
            return new RestrictedCollectionWrappedList<Cookie>(this.cookies.values());
        }
        return null;
    }

    public boolean clearExpired(Date date) {
        throw new RuntimeException("not implemented");
    }

    public static class RestrictedCollectionWrappedList<T>
    implements List<T> {
        private Collection<T> wrapped;

        public RestrictedCollectionWrappedList(Collection<T> wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public int size() {
            return this.wrapped.size();
        }

        @Override
        public boolean isEmpty() {
            throw new RuntimeException("not implemented");
        }

        @Override
        public boolean contains(Object o) {
            throw new RuntimeException("not implemented");
        }

        @Override
        public Iterator<T> iterator() {
            return this.wrapped.iterator();
        }

        @Override
        public Object[] toArray() {
            return IteratorUtils.toArray(this.wrapped.iterator());
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return IteratorUtils.toArray(this.iterator(), a.getClass());
        }

        @Override
        public boolean add(T e) {
            throw new RuntimeException("immutable list");
        }

        @Override
        public boolean remove(Object o) {
            throw new RuntimeException("immutable list");
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.wrapped.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            throw new RuntimeException("immutable list");
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            throw new RuntimeException("immutable list");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new RuntimeException("immutable list");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new RuntimeException("immutable list");
        }

        @Override
        public void clear() {
            throw new RuntimeException("immutable list");
        }

        @Override
        public T get(int index) {
            throw new RuntimeException("not implemented");
        }

        @Override
        public T set(int index, T element) {
            throw new RuntimeException("immutable list");
        }

        @Override
        public void add(int index, T element) {
            throw new RuntimeException("immutable list");
        }

        @Override
        public T remove(int index) {
            throw new RuntimeException("immutable list");
        }

        @Override
        public int indexOf(Object o) {
            throw new RuntimeException("not implemented");
        }

        @Override
        public int lastIndexOf(Object o) {
            throw new RuntimeException("not implemented");
        }

        @Override
        public ListIterator<T> listIterator() {
            throw new RuntimeException("not implemented");
        }

        @Override
        public ListIterator<T> listIterator(int index) {
            throw new RuntimeException("not implemented");
        }

        @Override
        public List<T> subList(int fromIndex, int toIndex) {
            throw new RuntimeException("not implemented");
        }
    }
}

