/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.fetcher;

import java.io.Closeable;
import java.io.Serializable;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.collections.Closure;
import org.archive.modules.net.CrawlHost;
import org.archive.modules.net.CrawlServer;
import org.archive.modules.net.ServerCache;
import org.archive.util.ObjectIdentityCache;
import org.archive.util.ObjectIdentityMemCache;
import org.archive.util.Supplier;

public class DefaultServerCache
extends ServerCache
implements Closeable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(DefaultServerCache.class.getName());
    protected ObjectIdentityCache<CrawlServer> servers = null;
    protected ObjectIdentityCache<CrawlHost> hosts = null;

    public DefaultServerCache() {
        this((ObjectIdentityCache<CrawlServer>)new ObjectIdentityMemCache(), (ObjectIdentityCache<CrawlHost>)new ObjectIdentityMemCache());
    }

    public DefaultServerCache(ObjectIdentityCache<CrawlServer> servers, ObjectIdentityCache<CrawlHost> hosts) {
        this.servers = servers;
        this.hosts = hosts;
    }

    @Override
    public CrawlServer getServerFor(final String serverKey) {
        CrawlServer cserver = (CrawlServer)this.servers.getOrUse(serverKey, (Supplier)new Supplier<CrawlServer>(){

            public CrawlServer get() {
                String skey = new String(serverKey);
                return new CrawlServer(skey);
            }
        });
        return cserver;
    }

    @Override
    public CrawlHost getHostFor(final String hostname) {
        if (hostname == null || hostname.length() == 0) {
            return null;
        }
        CrawlHost host = (CrawlHost)this.hosts.getOrUse(hostname, (Supplier)new Supplier<CrawlHost>(){

            public CrawlHost get() {
                String hkey = new String(hostname);
                return new CrawlHost(hkey);
            }
        });
        if (host != null && host.getIP() != null && "0.0.0.0".equals(host.getIP().getHostAddress())) {
            throw new IllegalStateException("got suspicious value 0.0.0.0 for " + hostname);
        }
        return host;
    }

    public boolean containsServer(String serverKey) {
        return (CrawlServer)this.servers.get(serverKey) != null;
    }

    public boolean containsHost(String hostKey) {
        return (CrawlHost)this.hosts.get(hostKey) != null;
    }

    @Override
    public void close() {
        if (this.hosts != null) {
            this.hosts.close();
            this.hosts = null;
        }
        if (this.servers != null) {
            this.servers.close();
            this.servers = null;
        }
    }

    @Override
    public void forAllHostsDo(Closure c) {
        for (String host : this.hosts.keySet()) {
            c.execute((Object)this.hosts.get(host));
        }
    }

    @Override
    public Set<String> hostKeys() {
        return this.hosts.keySet();
    }
}

