/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.fetcher;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.lang.StringUtils;
import org.archive.modules.CrawlURI;
import org.archive.modules.Processor;
import org.archive.modules.net.CrawlHost;
import org.archive.modules.net.ServerCache;
import org.archive.util.ArchiveUtils;
import org.archive.util.InetAddressUtil;
import org.archive.util.Recorder;
import org.springframework.beans.factory.annotation.Autowired;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.DohResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ResolverConfig;
import org.xbill.DNS.TextParseException;

public class FetchDNS
extends Processor {
    private static final long serialVersionUID = 3L;
    private static Logger logger = Logger.getLogger(FetchDNS.class.getName());
    private short ClassType = 1;
    private short TypeType = 1;
    protected InetAddress serverInetAddr = null;
    protected ServerCache serverCache;
    protected String digestAlgorithm;
    private static final long DEFAULT_TTL_FOR_NON_DNS_RESOLVES = 21600L;

    public boolean getAcceptNonDnsResolves() {
        return (Boolean)this.kp.get("acceptNonDnsResolves");
    }

    public void setAcceptNonDnsResolves(boolean acceptNonDnsResolves) {
        this.kp.put((Object)"acceptNonDnsResolves", (Object)acceptNonDnsResolves);
    }

    public boolean getDisableJavaDnsResolves() {
        return (Boolean)this.kp.get("disableJavaDnsResolves");
    }

    public void setDisableJavaDnsResolves(boolean disableJavaDnsResolves) {
        this.kp.put((Object)"disableJavaDnsResolves", (Object)disableJavaDnsResolves);
    }

    public String getDnsOverHttpServer() {
        return (String)this.kp.get("dnsOverHttpServer");
    }

    public void setDnsOverHttpServer(String dnsOverHttpServer) {
        this.kp.put((Object)"dnsOverHttpServer", (Object)dnsOverHttpServer);
    }

    public ServerCache getServerCache() {
        return this.serverCache;
    }

    @Autowired
    public void setServerCache(ServerCache serverCache) {
        this.serverCache = serverCache;
    }

    public boolean getDigestContent() {
        return (Boolean)this.kp.get("digestContent");
    }

    public void setDigestContent(boolean digest) {
        this.kp.put((Object)"digestContent", (Object)digest);
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(String digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    public FetchDNS() {
        this.setAcceptNonDnsResolves(false);
        this.setDisableJavaDnsResolves(false);
        this.setDigestContent(true);
        this.digestAlgorithm = "sha1";
    }

    @Override
    protected boolean shouldProcess(CrawlURI curi) {
        return curi.getUURI().getScheme().equals("dns");
    }

    @Override
    protected void innerProcess(CrawlURI curi) {
        String lookupName;
        Record[] rrecordSet = null;
        String dnsName = null;
        try {
            dnsName = curi.getUURI().getReferencedHost();
        }
        catch (URIException e) {
            logger.log(Level.SEVERE, "Failed parse of dns record " + curi, e);
        }
        if (dnsName == null) {
            curi.setFetchStatus(-7);
            return;
        }
        CrawlHost targetHost = this.getServerCache().getHostFor(dnsName);
        if (this.isQuadAddress(curi, dnsName, targetHost)) {
            return;
        }
        curi.setFetchBeginTime(System.currentTimeMillis());
        String string = lookupName = dnsName.endsWith(".") ? dnsName : dnsName + ".";
        if (!this.getDisableJavaDnsResolves()) {
            try {
                rrecordSet = this.createDNSLookup(lookupName).run();
            }
            catch (TextParseException e) {
                rrecordSet = null;
            }
        }
        curi.setContentType("text/dns");
        if (rrecordSet != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Found recordset for " + lookupName);
            }
            this.storeDNSRecord(curi, dnsName, targetHost, rrecordSet);
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Failed find of recordset for " + lookupName);
            }
            if (this.getAcceptNonDnsResolves() || this.getDisableJavaDnsResolves() || "localhost".equals(dnsName)) {
                InetAddress address = null;
                try {
                    address = InetAddress.getByName(dnsName);
                }
                catch (UnknownHostException e1) {
                    address = null;
                }
                if (address != null) {
                    targetHost.setIP(address, 21600L);
                    curi.setFetchStatus(1001);
                    curi.setContentSize(0L);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Found address for " + dnsName + " using native dns.");
                    }
                } else {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Failed find of address for " + dnsName + " using native dns.");
                    }
                    this.setUnresolvable(curi, targetHost);
                }
            } else {
                this.setUnresolvable(curi, targetHost);
            }
        }
        curi.setFetchCompletedTime(System.currentTimeMillis());
    }

    protected void storeDNSRecord(CrawlURI curi, String dnsName, CrawlHost targetHost, Record[] rrecordSet) {
        ARecord arecord = this.getFirstARecord(rrecordSet);
        if (arecord == null) {
            throw new NullPointerException("Got null arecord for " + dnsName);
        }
        targetHost.setIP(arecord.getAddress(), arecord.getTTL());
        try {
            this.recordDNS(curi, rrecordSet);
            curi.setFetchStatus(1);
            curi.setServerIP(ResolverConfig.getCurrentConfig().server().getAddress().getHostAddress());
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Failed store of DNS Record for " + curi.toString(), e);
            this.setUnresolvable(curi, targetHost);
        }
    }

    protected boolean isQuadAddress(CrawlURI curi, String dnsName, CrawlHost targetHost) {
        boolean result = false;
        Matcher matcher = InetAddressUtil.IPV4_QUADS.matcher(dnsName);
        if (matcher == null || !matcher.matches()) {
            return result;
        }
        result = true;
        if (logger.isLoggable(Level.WARNING)) {
            logger.warning("Unnecessary DNS CrawlURI created: " + curi);
        }
        try {
            targetHost.setIP(InetAddress.getByAddress(dnsName, new byte[]{(byte)new Integer(matcher.group(1)).intValue(), (byte)new Integer(matcher.group(2)).intValue(), (byte)new Integer(matcher.group(3)).intValue(), (byte)new Integer(matcher.group(4)).intValue()}), -1L);
            curi.setFetchStatus(1);
        }
        catch (UnknownHostException e) {
            logger.log(Level.SEVERE, "Should never be " + e.getMessage(), e);
            this.setUnresolvable(curi, targetHost);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recordDNS(CrawlURI curi, Record[] rrecordSet) throws IOException {
        byte[] dnsRecord = this.getDNSRecord(curi.getFetchBeginTime(), rrecordSet);
        Recorder rec = curi.getRecorder();
        boolean digestContent = this.getDigestContent();
        String algorithm = null;
        if (digestContent) {
            algorithm = this.getDigestAlgorithm();
            rec.getRecordedInput().setDigest(algorithm);
        } else {
            rec.getRecordedInput().setDigest((MessageDigest)null);
        }
        InputStream is = curi.getRecorder().inputWrap((InputStream)new ByteArrayInputStream(dnsRecord));
        if (digestContent) {
            rec.getRecordedInput().startDigest();
        }
        try {
            byte[] buf = new byte[256];
            while (is.read(buf) != -1) {
            }
        }
        finally {
            is.close();
            rec.closeRecorders();
        }
        curi.setContentSize(dnsRecord.length);
        if (digestContent) {
            curi.setContentDigest(algorithm, rec.getRecordedInput().getDigestValue());
        }
    }

    protected byte[] getDNSRecord(long fetchStart, Record[] rrecordSet) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] fetchDate = ArchiveUtils.get14DigitDate((long)fetchStart).getBytes();
        baos.write(fetchDate);
        baos.write("\n".getBytes());
        if (rrecordSet != null) {
            for (int i = 0; i < rrecordSet.length; ++i) {
                byte[] record = rrecordSet[i].toString().getBytes();
                baos.write(record);
                baos.write("\n".getBytes());
            }
        }
        return baos.toByteArray();
    }

    protected void setUnresolvable(CrawlURI curi, CrawlHost host) {
        host.setIP(null, 0L);
        curi.setFetchStatus(-1);
    }

    protected ARecord getFirstARecord(Record[] rrecordSet) {
        ARecord arecord = null;
        if (rrecordSet == null || rrecordSet.length == 0) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("rrecordSet is null or zero length: " + rrecordSet);
            }
            return arecord;
        }
        for (int i = 0; i < rrecordSet.length; ++i) {
            if (rrecordSet[i].getType() != 1) {
                if (!logger.isLoggable(Level.FINEST)) continue;
                logger.finest("Record " + Integer.toString(i) + " is not A type but " + rrecordSet[i].getType());
                continue;
            }
            arecord = (ARecord)rrecordSet[i];
            break;
        }
        return arecord;
    }

    protected Lookup createDNSLookup(String lookupName) throws TextParseException {
        Lookup lookup = new Lookup(lookupName, (int)this.TypeType, (int)this.ClassType);
        String dohServer = this.getDnsOverHttpServer();
        if (StringUtils.isNotEmpty((String)dohServer)) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "use dns on http with server " + dohServer);
            }
            DohResolver hts = new DohResolver(dohServer);
            lookup.setResolver((Resolver)hts);
        }
        return lookup;
    }

    static {
        Lookup.getDefaultCache((int)1).setMaxEntries(1);
        try {
            new Lookup("localhost").run();
        }
        catch (TextParseException e) {
            throw new RuntimeException(e);
        }
    }
}

