/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.fetcher;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.SocketFactory;
import org.apache.commons.httpclient.URIException;
import org.archive.io.RecordingInputStream;
import org.archive.io.ReplayCharSequence;
import org.archive.modules.CrawlURI;
import org.archive.modules.Processor;
import org.archive.modules.extractor.Hop;
import org.archive.modules.extractor.LinkContext;
import org.archive.net.ClientFTP;
import org.archive.net.UURI;
import org.archive.net.UURIFactory;
import org.archive.util.Recorder;

public class FetchFTP
extends Processor {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(FetchFTP.class.getName());
    private static Pattern DIR = Pattern.compile("(.+)$", 8);
    protected String digestAlgorithm;
    protected SocketFactoryWithTimeout socketFactory;

    public String getUsername() {
        return (String)this.kp.get("username");
    }

    public void setUsername(String username) {
        this.kp.put((Object)"username", (Object)username);
    }

    public String getPassword() {
        return (String)this.kp.get("password");
    }

    public void setPassword(String pw) {
        this.kp.put((Object)"password", (Object)pw);
    }

    public boolean getExtractFromDirs() {
        return (Boolean)this.kp.get("extractFromDirs");
    }

    public void setExtractFromDirs(boolean extractFromDirs) {
        this.kp.put((Object)"extractFromDirs", (Object)extractFromDirs);
    }

    public boolean getExtractParent() {
        return (Boolean)this.kp.get("extractParent");
    }

    public void setExtractParent(boolean extractParent) {
        this.kp.put((Object)"extractParent", (Object)extractParent);
    }

    public boolean getDigestContent() {
        return (Boolean)this.kp.get("digestContent");
    }

    public void setDigestContent(boolean digest) {
        this.kp.put((Object)"digestContent", (Object)digest);
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(String digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    public long getMaxLengthBytes() {
        return (Long)this.kp.get("maxLengthBytes");
    }

    public void setMaxLengthBytes(long timeout) {
        this.kp.put((Object)"maxLengthBytes", (Object)timeout);
    }

    public int getMaxFetchKBSec() {
        return (Integer)this.kp.get("maxFetchKBSec");
    }

    public void setMaxFetchKBSec(int rate) {
        this.kp.put((Object)"maxFetchKBSec", (Object)rate);
    }

    public int getTimeoutSeconds() {
        return (Integer)this.kp.get("timeoutSeconds");
    }

    public void setTimeoutSeconds(int timeout) {
        this.kp.put((Object)"timeoutSeconds", (Object)timeout);
    }

    public int getSoTimeoutMs() {
        return (Integer)this.kp.get("soTimeoutMs");
    }

    public void setSoTimeoutMs(int timeout) {
        this.kp.put((Object)"soTimeoutMs", (Object)timeout);
    }

    public FetchFTP() {
        this.setUsername("anonymous");
        this.setPassword("password");
        this.setExtractFromDirs(true);
        this.setExtractParent(true);
        this.setDigestContent(true);
        this.digestAlgorithm = "sha1";
        this.setMaxLengthBytes(0L);
        this.setMaxFetchKBSec(0);
        this.setTimeoutSeconds(1200);
        this.setSoTimeoutMs(20000);
    }

    @Override
    protected boolean shouldProcess(CrawlURI curi) {
        return curi.getUURI().getScheme().equals("ftp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void innerProcess(CrawlURI curi) throws InterruptedException {
        curi.setFetchBeginTime(System.currentTimeMillis());
        ClientFTP client = new ClientFTP();
        Recorder recorder = curi.getRecorder();
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("attempting to fetch ftp uri: " + curi);
            }
            this.fetch(curi, client, recorder);
        }
        catch (IOException e) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info(curi + ": " + e);
            }
            curi.getNonFatalFailures().add(e);
            curi.setFetchStatus(-2);
        }
        finally {
            FetchFTP.disconnect(client);
            curi.setFetchCompletedTime(System.currentTimeMillis());
            curi.getData().put("ftp-control-conversation", client.getControlConversation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetch(CrawlURI curi, ClientFTP client, Recorder recorder) throws IOException, InterruptedException {
        String path;
        int command;
        UURI uuri = curi.getUURI();
        int port = uuri.getPort();
        if (port == -1) {
            port = 21;
        }
        if (this.socketFactory == null) {
            this.socketFactory = new SocketFactoryWithTimeout();
        }
        this.socketFactory.setConnectTimeoutMs(this.getSoTimeoutMs());
        client.setSocketFactory((SocketFactory)this.socketFactory);
        client.setConnectTimeout(this.getSoTimeoutMs());
        client.setDefaultTimeout(this.getSoTimeoutMs());
        client.setDataTimeout(this.getSoTimeoutMs());
        client.connect(uuri.getHost(), port);
        client.setSoTimeout(this.getSoTimeoutMs());
        String[] auth = this.getAuth(curi);
        client.login(auth[0], auth[1]);
        boolean isDirectory = client.changeWorkingDirectory(uuri.getPath());
        if (isDirectory) {
            curi.getAnnotations().add("ftpDirectoryList");
            command = 27;
            client.setFileType(0);
            path = ".";
        } else {
            command = 13;
            client.setFileType(2);
            path = uuri.getPath();
        }
        client.enterLocalPassiveMode();
        Socket socket = null;
        try {
            socket = client.openDataConnection(command, path);
            curi.setFetchStatus(client.getReplyCode());
            curi.getData().put("ftp-fetch-status", client.getReplyStrings()[0]);
        }
        catch (IOException e) {
            curi.setFetchStatus(-3);
        }
        if (socket != null) {
            if (socket.getSoTimeout() != this.getSoTimeoutMs()) {
                logger.warning("data socket timeout " + socket.getSoTimeout() + "ms is not expected value " + this.getSoTimeoutMs() + "ms");
            }
            boolean digestContent = this.getDigestContent();
            String algorithm = null;
            if (digestContent) {
                algorithm = this.getDigestAlgorithm();
                recorder.getRecordedInput().setDigest(algorithm);
                recorder.getRecordedInput().startDigest();
            } else {
                recorder.getRecordedInput().setDigest((MessageDigest)null);
            }
            curi.setServerIP(socket.getInetAddress().getHostAddress());
            try {
                this.saveToRecorder(curi, socket, recorder);
            }
            finally {
                recorder.close();
                client.closeDataConnection();
                curi.setContentSize(recorder.getRecordedInput().getSize());
                client.getReply();
                curi.setFetchStatus(client.getReplyCode());
                curi.getData().put("ftp-fetch-status", client.getReplyStrings()[0]);
                if (isDirectory) {
                    curi.setContentType("text/plain");
                } else {
                    curi.setContentType("application/octet-stream");
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("read " + recorder.getRecordedInput().getSize() + " bytes from ftp data socket");
                }
                if (digestContent) {
                    curi.setContentDigest(algorithm, recorder.getRecordedInput().getDigestValue());
                }
            }
            if (isDirectory) {
                this.extract(curi, recorder);
            }
        } else {
            curi.setContentSize(0L);
        }
        this.addParent(curi);
    }

    private void saveToRecorder(CrawlURI curi, Socket socket, Recorder recorder) throws IOException, InterruptedException {
        recorder.inputWrap(socket.getInputStream());
        recorder.outputWrap(socket.getOutputStream());
        recorder.markContentBegin();
        long softMax = 0L;
        long hardMax = this.getMaxLengthBytes();
        long timeout = (long)this.getTimeoutSeconds() * 1000L;
        int maxRate = this.getMaxFetchKBSec();
        RecordingInputStream input = recorder.getRecordedInput();
        input.setLimits(hardMax, timeout, (long)maxRate);
        input.readFullyOrUntil(softMax);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extract(CrawlURI curi, Recorder recorder) {
        if (!this.getExtractFromDirs()) {
            return;
        }
        ReplayCharSequence seq = null;
        try {
            seq = recorder.getContentReplayCharSequence();
            this.extract(curi, seq);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "IO error during extraction.", e);
        }
        catch (RuntimeException e) {
            logger.log(Level.SEVERE, "IO error during extraction.", e);
        }
        finally {
            FetchFTP.close(seq);
        }
    }

    private void extract(CrawlURI curi, ReplayCharSequence dir) {
        logger.log(Level.FINEST, "Extracting URIs from FTP directory.");
        Matcher matcher = DIR.matcher((CharSequence)dir);
        while (matcher.find()) {
            String file = matcher.group(1);
            this.addExtracted(curi, file);
        }
    }

    private void addExtracted(CrawlURI curi, String file) {
        String base;
        try {
            file = URLEncoder.encode(file, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Found " + file);
        }
        if ((base = curi.toString()).endsWith("/")) {
            base = base.substring(0, base.length() - 1);
        }
        try {
            UURI n = UURIFactory.getInstance((String)(base + "/" + file));
            CrawlURI link = curi.createCrawlURI(n, LinkContext.NAVLINK_MISC, Hop.NAVLINK);
            curi.getOutLinks().add(link);
        }
        catch (URIException e) {
            logger.log(Level.WARNING, "URI error during extraction.", e);
        }
    }

    private void addParent(CrawlURI curi) {
        if (!this.getExtractParent()) {
            return;
        }
        UURI uuri = curi.getUURI();
        try {
            if (uuri.getPath().equals("/")) {
                return;
            }
            String scheme = uuri.getScheme();
            String auth = uuri.getEscapedAuthority();
            String path = uuri.getEscapedCurrentHierPath();
            UURI parent = UURIFactory.getInstance((String)(scheme + "://" + auth + path));
            CrawlURI link = curi.createCrawlURI(parent, LinkContext.NAVLINK_MISC, Hop.NAVLINK);
            curi.getOutLinks().add(link);
        }
        catch (URIException e) {
            logger.log(Level.WARNING, "URI error during extraction.", e);
        }
    }

    private String[] getAuth(CrawlURI curi) {
        int p;
        String userinfo;
        String[] result = new String[2];
        UURI uuri = curi.getUURI();
        try {
            userinfo = uuri.getUserinfo();
        }
        catch (URIException e) {
            assert (false);
            logger.finest("getUserinfo raised URIException.");
            userinfo = null;
        }
        if (userinfo != null && (p = userinfo.indexOf(58)) > 0) {
            result[0] = userinfo.substring(0, p);
            result[1] = userinfo.substring(p + 1);
            return result;
        }
        result[0] = this.getUsername();
        result[1] = this.getPassword();
        return result;
    }

    private static void close(ReplayCharSequence seq) {
        if (seq == null) {
            return;
        }
        try {
            seq.close();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "IO error closing ReplayCharSequence.", e);
        }
    }

    private static void disconnect(ClientFTP client) {
        if (client.isConnected()) {
            try {
                client.logout();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (client.isConnected()) {
            try {
                client.disconnect();
            }
            catch (IOException e) {
                logger.warning("Could not disconnect from FTP client: " + e);
            }
        }
    }

    public class SocketFactoryWithTimeout
    extends SocketFactory {
        protected int connectTimeoutMs = 0;

        public int getConnectTimeoutMs() {
            return this.connectTimeoutMs;
        }

        public void setConnectTimeoutMs(int connectTimeoutMs) {
            this.connectTimeoutMs = connectTimeoutMs;
        }

        @Override
        public Socket createSocket() {
            return new Socket();
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            Socket sock = this.createSocket();
            sock.connect(new InetSocketAddress(host, port), this.connectTimeoutMs);
            return sock;
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            Socket sock = this.createSocket();
            sock.connect(new InetSocketAddress(host, port), this.connectTimeoutMs);
            return sock;
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
            Socket sock = this.createSocket();
            sock.bind(new InetSocketAddress(localHost, localPort));
            sock.connect(new InetSocketAddress(host, port), this.connectTimeoutMs);
            return sock;
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            Socket sock = this.createSocket();
            sock.bind(new InetSocketAddress(localAddress, localPort));
            sock.connect(new InetSocketAddress(address, port), this.connectTimeoutMs);
            return sock;
        }
    }
}

