/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.fetcher;

import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.AbstractExecutionAwareRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.DigestSchemeFactory;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.impl.client.TargetAuthenticationStrategy;
import org.apache.http.message.BasicHeader;
import org.archive.httpclient.ConfigurableX509TrustManager;
import org.archive.io.RecorderLengthExceededException;
import org.archive.io.RecorderTimeoutException;
import org.archive.modules.CrawlURI;
import org.archive.modules.Processor;
import org.archive.modules.credential.Credential;
import org.archive.modules.credential.CredentialStore;
import org.archive.modules.credential.HttpAuthenticationCredential;
import org.archive.modules.deciderules.AcceptDecideRule;
import org.archive.modules.deciderules.DecideResult;
import org.archive.modules.deciderules.DecideRule;
import org.archive.modules.fetcher.AbstractCookieStore;
import org.archive.modules.fetcher.FetchHTTPRequest;
import org.archive.modules.fetcher.UserAgentProvider;
import org.archive.modules.net.CrawlHost;
import org.archive.modules.net.CrawlServer;
import org.archive.modules.net.ServerCache;
import org.archive.util.Recorder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.Lifecycle;

public class FetchHTTP
extends Processor
implements Lifecycle {
    private static Logger logger = Logger.getLogger(FetchHTTP.class.getName());
    public static final String HTTP_SCHEME = "http";
    public static final String HTTPS_SCHEME = "https";
    protected static final Lookup<AuthSchemeProvider> AUTH_SCHEME_REGISTRY;
    protected ServerCache serverCache;
    protected String digestAlgorithm;
    protected AbstractCookieStore cookieStore;
    public static final String HTTP_BIND_ADDRESS = "httpBindAddress";
    protected ConfigurableX509TrustManager.TrustLevel sslTrustLevel;
    protected transient SSLContext sslContext;

    public FetchHTTP() {
        this.setDigestContent(true);
        this.digestAlgorithm = "sha1";
        this.setSendConnectionClose(true);
        this.setDefaultEncoding("ISO-8859-1");
        this.setUseHTTP11(false);
        this.setIgnoreCookies(false);
        this.setSendReferer(true);
        this.setAcceptCompression(false);
        this.setAcceptHeaders(Arrays.asList("Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8"));
        this.setCredentialStore(new CredentialStore());
        this.setMaxFetchKBSec(0);
        this.setTimeoutSeconds(1200);
        this.setSoTimeoutMs(20000);
        this.setMaxLengthBytes(0L);
        this.setSendRange(false);
        this.setSendIfModifiedSince(true);
        this.setSendIfNoneMatch(true);
        this.setShouldFetchBodyRule(new AcceptDecideRule());
        this.sslTrustLevel = ConfigurableX509TrustManager.TrustLevel.OPEN;
    }

    public ServerCache getServerCache() {
        return this.serverCache;
    }

    @Autowired
    public void setServerCache(ServerCache serverCache) {
        this.serverCache = serverCache;
    }

    public boolean getDigestContent() {
        return (Boolean)this.kp.get("digestContent");
    }

    public void setDigestContent(boolean digest) {
        this.kp.put((Object)"digestContent", (Object)digest);
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(String digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    public UserAgentProvider getUserAgentProvider() {
        return (UserAgentProvider)this.kp.get("userAgentProvider");
    }

    @Autowired
    public void setUserAgentProvider(UserAgentProvider provider) {
        this.kp.put((Object)"userAgentProvider", (Object)provider);
    }

    public boolean getSendConnectionClose() {
        return (Boolean)this.kp.get("sendConnectionClose");
    }

    public void setSendConnectionClose(boolean sendClose) {
        this.kp.put((Object)"sendConnectionClose", (Object)sendClose);
    }

    public String getDefaultEncoding() {
        return this.getDefaultCharset().name();
    }

    public void setDefaultEncoding(String encoding) {
        this.kp.put((Object)"defaultEncoding", (Object)Charset.forName(encoding));
    }

    public Charset getDefaultCharset() {
        return (Charset)this.kp.get("defaultEncoding");
    }

    public boolean getUseHTTP11() {
        return (Boolean)this.kp.get("useHTTP11");
    }

    public void setUseHTTP11(boolean useHTTP11) {
        this.kp.put((Object)"useHTTP11", (Object)useHTTP11);
    }

    protected ProtocolVersion getConfiguredHttpVersion() {
        if (this.getUseHTTP11()) {
            return HttpVersion.HTTP_1_1;
        }
        return HttpVersion.HTTP_1_0;
    }

    public boolean getIgnoreCookies() {
        return (Boolean)this.kp.get("ignoreCookies");
    }

    public void setIgnoreCookies(boolean ignoreCookies) {
        this.kp.put((Object)"ignoreCookies", (Object)ignoreCookies);
    }

    public boolean getSendReferer() {
        return (Boolean)this.kp.get("sendReferer");
    }

    public void setSendReferer(boolean sendReferer) {
        this.kp.put((Object)"sendReferer", (Object)sendReferer);
    }

    public boolean getAcceptCompression() {
        return (Boolean)this.kp.get("acceptCompression");
    }

    public void setAcceptCompression(boolean acceptCompression) {
        this.kp.put((Object)"acceptCompression", (Object)acceptCompression);
    }

    public List<String> getAcceptHeaders() {
        return (List)this.kp.get("acceptHeaders");
    }

    public void setAcceptHeaders(List<String> headers) {
        this.kp.put((Object)"acceptHeaders", headers);
    }

    @Autowired(required=false)
    public void setCookieStore(AbstractCookieStore cookieStore) {
        this.cookieStore = cookieStore;
    }

    public AbstractCookieStore getCookieStore() {
        return this.cookieStore;
    }

    public CredentialStore getCredentialStore() {
        return (CredentialStore)this.kp.get("credentialStore");
    }

    @Autowired(required=false)
    public void setCredentialStore(CredentialStore credentials) {
        this.kp.put((Object)"credentialStore", (Object)credentials);
    }

    public String getHttpBindAddress() {
        return (String)this.kp.get(HTTP_BIND_ADDRESS);
    }

    public void setHttpBindAddress(String address) {
        this.kp.put((Object)HTTP_BIND_ADDRESS, (Object)address);
    }

    public String getHttpProxyHost() {
        return (String)this.kp.get("httpProxyHost");
    }

    public void setHttpProxyHost(String host) {
        this.kp.put((Object)"httpProxyHost", (Object)host);
    }

    public Integer getHttpProxyPort() {
        return (Integer)this.kp.get("httpProxyPort");
    }

    public void setHttpProxyPort(Integer port) {
        this.kp.put((Object)"httpProxyPort", (Object)port);
    }

    public String getHttpProxyUser() {
        return (String)this.kp.get("httpProxyUser");
    }

    public void setHttpProxyUser(String user) {
        this.kp.put((Object)"httpProxyUser", (Object)user);
    }

    public String getHttpProxyPassword() {
        return (String)this.kp.get("httpProxyPassword");
    }

    public void setHttpProxyPassword(String password) {
        this.kp.put((Object)"httpProxyPassword", (Object)password);
    }

    public int getMaxFetchKBSec() {
        return (Integer)this.kp.get("maxFetchKBSec");
    }

    public void setMaxFetchKBSec(int rate) {
        this.kp.put((Object)"maxFetchKBSec", (Object)rate);
    }

    public int getTimeoutSeconds() {
        return (Integer)this.kp.get("timeoutSeconds");
    }

    public void setTimeoutSeconds(int timeout) {
        this.kp.put((Object)"timeoutSeconds", (Object)timeout);
    }

    public int getSoTimeoutMs() {
        return (Integer)this.kp.get("soTimeoutMs");
    }

    public void setSoTimeoutMs(int timeout) {
        this.kp.put((Object)"soTimeoutMs", (Object)timeout);
    }

    public long getMaxLengthBytes() {
        return (Long)this.kp.get("maxLengthBytes");
    }

    public void setMaxLengthBytes(long timeout) {
        this.kp.put((Object)"maxLengthBytes", (Object)timeout);
    }

    public boolean getSendRange() {
        return (Boolean)this.kp.get("sendRange");
    }

    public void setSendRange(boolean sendRange) {
        this.kp.put((Object)"sendRange", (Object)sendRange);
    }

    public boolean getSendIfModifiedSince() {
        return (Boolean)this.kp.get("sendIfModifiedSince");
    }

    public void setSendIfModifiedSince(boolean sendIfModifiedSince) {
        this.kp.put((Object)"sendIfModifiedSince", (Object)sendIfModifiedSince);
    }

    public boolean getSendIfNoneMatch() {
        return (Boolean)this.kp.get("sendIfNoneMatch");
    }

    public void setSendIfNoneMatch(boolean sendIfNoneMatch) {
        this.kp.put((Object)"sendIfNoneMatch", (Object)sendIfNoneMatch);
    }

    public DecideRule getShouldFetchBodyRule() {
        return (DecideRule)this.kp.get("shouldFetchBodyRule");
    }

    public void setShouldFetchBodyRule(DecideRule rule) {
        this.kp.put((Object)"shouldFetchBodyRule", (Object)rule);
    }

    public ConfigurableX509TrustManager.TrustLevel getSslTrustLevel() {
        return this.sslTrustLevel;
    }

    public synchronized void setSslTrustLevel(ConfigurableX509TrustManager.TrustLevel sslTrustLevel) {
        if (sslTrustLevel != this.sslTrustLevel) {
            this.sslTrustLevel = sslTrustLevel;
            this.sslContext = null;
        }
    }

    public String getSocksProxyHost() {
        return (String)this.kp.get("socksProxyHost");
    }

    public void setSocksProxyHost(String socksProxyHost) {
        this.kp.put((Object)"socksProxyHost", (Object)socksProxyHost);
    }

    public Integer getSocksProxyPort() {
        return (Integer)this.kp.get("socksProxyPort");
    }

    public void setSocksProxyPort(Integer socksProxyPort) {
        this.kp.put((Object)"socksProxyPort", (Object)socksProxyPort);
    }

    protected synchronized SSLContext sslContext() {
        if (this.sslContext == null) {
            try {
                ConfigurableX509TrustManager trustManager = new ConfigurableX509TrustManager(this.getSslTrustLevel());
                this.sslContext = SSLContext.getInstance("SSL");
                this.sslContext.init(null, new TrustManager[]{trustManager}, null);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed configure of ssl context " + e.getMessage(), e);
            }
        }
        return this.sslContext;
    }

    @Override
    protected boolean shouldProcess(CrawlURI curi) {
        String scheme = curi.getUURI().getScheme();
        if (!scheme.equals(HTTP_SCHEME) && !scheme.equals(HTTPS_SCHEME)) {
            return false;
        }
        CrawlHost host = this.getServerCache().getHostFor(curi.getUURI());
        if (host.getIP() == null && host.hasBeenLookedUp()) {
            curi.setFetchStatus(-6);
            return false;
        }
        return true;
    }

    protected void setOtherCodings(CrawlURI uri, Recorder rec, HttpResponse response) {
        if (response.getEntity() != null) {
            rec.setInputIsChunked(response.getEntity().isChunked());
            Header contentEncodingHeader = response.getEntity().getContentEncoding();
            if (contentEncodingHeader != null) {
                String ce = contentEncodingHeader.getValue().trim();
                try {
                    rec.setContentEncoding(ce);
                }
                catch (IllegalArgumentException e) {
                    uri.getAnnotations().add("unsatisfiableContentEncoding:" + StringUtils.stripToEmpty((String)ce));
                }
            }
        }
    }

    protected void setCharacterEncoding(CrawlURI curi, Recorder rec, HttpResponse response) {
        rec.setCharset(this.getDefaultCharset());
        try {
            Charset charset = ContentType.getOrDefault((HttpEntity)response.getEntity()).getCharset();
            if (charset != null) {
                rec.setCharset(charset);
            }
        }
        catch (IllegalArgumentException e) {
            String unsatisfiableCharset;
            try {
                unsatisfiableCharset = response.getFirstHeader("content-type").getElements()[0].getParameterByName("charset").getValue();
            }
            catch (Exception f) {
                unsatisfiableCharset = "<failed-to-parse>";
            }
            curi.getAnnotations().add("unsatisfiableCharsetInHeader:" + StringUtils.stripToEmpty((String)unsatisfiableCharset));
        }
    }

    protected boolean checkMidfetchAbort(CrawlURI curi) {
        if (curi.isPrerequisite()) {
            return false;
        }
        DecideResult r = this.getShouldFetchBodyRule().decisionFor(curi);
        return r == DecideResult.REJECT;
    }

    protected void doAbort(CrawlURI curi, AbstractExecutionAwareRequest request, String annotation) {
        curi.getAnnotations().add(annotation);
        curi.getRecorder().close();
        request.abort();
    }

    protected boolean maybeMidfetchAbort(CrawlURI curi, AbstractExecutionAwareRequest request) {
        if (this.checkMidfetchAbort(curi)) {
            this.doAbort(curi, request, "midFetchAbort");
            curi.getRecorder().getRecordedInput().chopAtMessageBodyBegin();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void innerProcess(CrawlURI curi) throws InterruptedException {
        String contentLengthHeader;
        FetchHTTPRequest req;
        curi.setFetchBeginTime(System.currentTimeMillis());
        Recorder rec = curi.getRecorder();
        boolean digestContent = this.getDigestContent();
        String algorithm = null;
        if (digestContent) {
            algorithm = this.getDigestAlgorithm();
            rec.getRecordedInput().setDigest(algorithm);
        } else {
            rec.getRecordedInput().setDigest((MessageDigest)null);
        }
        try {
            req = new FetchHTTPRequest(this, curi);
        }
        catch (URIException e) {
            this.cleanup(curi, (Exception)((Object)e), e.getMessage(), -7);
            return;
        }
        rec.getRecordedInput().setLimits(this.getMaxLengthBytes(), 1000L * (long)this.getTimeoutSeconds(), (long)this.getMaxFetchKBSec());
        HttpResponse response = null;
        try {
            response = req.execute();
            this.addResponseContent(response, curi);
        }
        catch (ClientProtocolException e) {
            this.failedExecuteCleanup(curi, (Exception)((Object)e));
            return;
        }
        catch (IOException e) {
            if ("handshake alert:  unrecognized_name".equals(e.getMessage())) {
                req.setDisableSNI(true);
                try {
                    response = req.execute();
                    this.addResponseContent(response, curi);
                }
                catch (ClientProtocolException ee) {
                    this.failedExecuteCleanup(curi, e);
                    return;
                }
                catch (IOException ee) {
                    this.failedExecuteCleanup(curi, e);
                    return;
                }
            }
            this.failedExecuteCleanup(curi, e);
            return;
        }
        this.maybeMidfetchAbort(curi, req.request);
        long contentLength = -1L;
        Header h = response.getLastHeader("content-length");
        if (h != null && !(contentLengthHeader = StringUtils.substringBefore((String)h.getValue(), (String)"\u0000").trim()).isEmpty()) {
            try {
                contentLength = Long.parseLong(contentLengthHeader);
            }
            catch (NumberFormatException e) {
                this.cleanup(curi, e, "invalid content-length header", -3);
                return;
            }
        }
        try {
            if (!req.request.isAborted()) {
                rec.getRecordedInput().readToEndOfContent(contentLength);
            }
        }
        catch (RecorderTimeoutException ex) {
            this.doAbort(curi, req.request, "timeTrunc");
        }
        catch (RecorderLengthExceededException ex) {
            this.doAbort(curi, req.request, "lenTrunc");
        }
        catch (IOException e) {
            this.cleanup(curi, e, "readFully", -3);
            return;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.cleanup(curi, e, "readFully", -3);
            return;
        }
        finally {
            rec.close();
            rec.closeRecorders();
            curi.setFetchCompletedTime(System.currentTimeMillis());
            this.setCharacterEncoding(curi, rec, response);
            this.setSizes(curi, rec);
            this.setOtherCodings(curi, rec, response);
        }
        if (digestContent) {
            curi.setContentDigest(algorithm, rec.getRecordedInput().getDigestValue());
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine((curi.getFetchType() == CrawlURI.FetchType.HTTP_POST ? "POST" : "GET") + " " + curi.getUURI().toString() + " " + response.getStatusLine().getStatusCode() + " " + rec.getRecordedInput().getSize() + " " + curi.getContentType());
        }
        if (FetchHTTP.isSuccess(curi) && req.addedCredentials) {
            this.promoteCredentials(curi);
        } else if (response.getStatusLine().getStatusCode() == 401) {
            this.handle401(response, curi);
        } else if (response.getStatusLine().getStatusCode() == 407) {
            this.kp.put((Object)"proxyAuthChallenges", this.extractChallenges(response, curi, (AuthenticationStrategy)ProxyAuthenticationStrategy.INSTANCE));
        }
        if (rec.getRecordedInput().isOpen()) {
            logger.severe(curi.toString() + " RIS still open. Should have been closed by method release: " + Thread.currentThread().getName());
            try {
                rec.getRecordedInput().close();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "second-chance RIS close failed", e);
            }
        }
    }

    protected void promoteCredentials(CrawlURI curi) {
        Set<Credential> credentials = curi.getCredentials();
        Iterator<Credential> i = credentials.iterator();
        while (i.hasNext()) {
            CrawlServer cs;
            Credential c = i.next();
            i.remove();
            String cd = c.getDomain();
            if (cd == null || (cs = this.serverCache.getServerFor(cd)) == null) continue;
            cs.addCredential(c);
            cs.setHttpAuthChallenges(curi.getHttpAuthChallenges());
        }
    }

    protected void handle401(HttpResponse response, CrawlURI curi) {
        Map<String, String> challenges = this.extractChallenges(response, curi, (AuthenticationStrategy)TargetAuthenticationStrategy.INSTANCE);
        AuthScheme authscheme = this.chooseAuthScheme(challenges, "WWW-Authenticate");
        curi.setHttpAuthChallenges(challenges);
        if (authscheme == null) {
            return;
        }
        String realm = authscheme.getRealm();
        Set<Credential> curiRfc2617Credentials = this.getCredentials(curi, HttpAuthenticationCredential.class);
        HttpAuthenticationCredential extant = HttpAuthenticationCredential.getByRealm(curiRfc2617Credentials, realm, curi);
        if (extant != null) {
            extant.detachAll(curi);
            logger.warning("Auth failed (401) though supplied realm " + realm + " to " + curi.toString());
        } else {
            String serverKey = FetchHTTP.getServerKey(curi);
            CrawlServer server = this.serverCache.getServerFor(serverKey);
            Set<Credential> storeRfc2617Credentials = this.getCredentialStore().subset(curi, HttpAuthenticationCredential.class, server.getName());
            if (storeRfc2617Credentials == null || storeRfc2617Credentials.size() <= 0) {
                logger.fine("No rfc2617 credentials for " + curi);
            } else {
                HttpAuthenticationCredential found = HttpAuthenticationCredential.getByRealm(storeRfc2617Credentials, realm, curi);
                if (found == null) {
                    logger.fine("No rfc2617 credentials for realm " + realm + " in " + curi);
                } else {
                    found.attach(curi);
                    logger.fine("Found credential for scheme " + authscheme + " realm " + realm + " in store for " + curi.toString());
                }
            }
        }
    }

    protected Map<String, String> extractChallenges(HttpResponse response, CrawlURI curi, AuthenticationStrategy authStrategy) {
        HashMap hcChallengeHeaders = null;
        try {
            hcChallengeHeaders = authStrategy.getChallenges(null, response, null);
        }
        catch (MalformedChallengeException e) {
            logger.fine("Failed challenge parse: " + e.getMessage());
            hcChallengeHeaders = new HashMap();
        }
        if (hcChallengeHeaders.size() < 1) {
            curi.getNonFatalFailures().add(new IllegalStateException("Missing auth challenge headers for uri with response status 401: " + curi));
        }
        HashMap<String, String> challenges = new HashMap<String, String>();
        for (Map.Entry challenge : hcChallengeHeaders.entrySet()) {
            challenges.put((String)challenge.getKey(), ((Header)challenge.getValue()).getValue());
        }
        return challenges;
    }

    protected AuthScheme chooseAuthScheme(Map<String, String> challenges, String challengeHeaderKey) {
        HashSet<String> authSchemesLeftToTry = new HashSet<String>(challenges.keySet());
        for (String authSchemeName : new String[]{"digest", "basic"}) {
            if (!authSchemesLeftToTry.remove(authSchemeName)) continue;
            AuthScheme authScheme = ((AuthSchemeProvider)AUTH_SCHEME_REGISTRY.lookup(authSchemeName)).create(null);
            BasicHeader challenge = new BasicHeader(challengeHeaderKey, challenges.get(authSchemeName));
            try {
                authScheme.processChallenge((Header)challenge);
            }
            catch (MalformedChallengeException e) {
                logger.fine(e.getMessage() + " " + challenge);
                continue;
            }
            if (authScheme.isConnectionBased()) {
                logger.fine("Connection based " + authScheme);
                continue;
            }
            if (authScheme.getRealm() == null || authScheme.getRealm().length() <= 0) {
                logger.fine("Empty realm " + authScheme);
                continue;
            }
            return authScheme;
        }
        for (String unsupportedSchemeName : authSchemesLeftToTry) {
            logger.fine("Unsupported http auth scheme: " + unsupportedSchemeName);
        }
        return null;
    }

    protected Set<Credential> getCredentials(CrawlURI curi, Class<?> type) {
        HashSet<Credential> result = null;
        if (curi.hasCredentials()) {
            for (Credential c : curi.getCredentials()) {
                if (!type.isInstance(c)) continue;
                if (result == null) {
                    result = new HashSet<Credential>();
                }
                result.add(c);
            }
        }
        return result;
    }

    protected Object getAttributeEither(CrawlURI curi, String key) {
        Object r = curi.getData().get(key);
        if (r != null) {
            return r;
        }
        return this.kp.get(key);
    }

    protected void setSizes(CrawlURI curi, Recorder rec) {
        HashMap<String, Object>[] history;
        curi.setContentSize(rec.getRecordedInput().getSize());
        curi.addExtraInfo("contentSize", rec.getRecordedInput().getSize());
        if (curi.getFetchStatus() == 304 && curi.getFetchHistory() != null && (history = curi.getFetchHistory())[0] != null && history[0].containsKey("reference-length")) {
            long referenceLength = (Long)history[0].get("reference-length");
            curi.getData().put("reference-length", referenceLength);
            curi.setContentSize(rec.getRecordedInput().getSize() + referenceLength);
        }
    }

    protected void addResponseContent(HttpResponse response, CrawlURI curi) {
        curi.setFetchStatus(response.getStatusLine().getStatusCode());
        Header ct = response.getLastHeader("content-type");
        curi.setContentType(ct == null ? null : ct.getValue());
        for (Header h : response.getAllHeaders()) {
            curi.putHttpResponseHeader(h.getName(), h.getValue());
        }
    }

    protected void failedExecuteCleanup(CrawlURI curi, Exception exception) {
        this.cleanup(curi, exception, "executeMethod", -2);
    }

    protected void cleanup(CrawlURI curi, Exception exception, String message, int status) {
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, message + ": " + exception, exception);
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine(message + ": " + exception);
        }
        curi.getNonFatalFailures().add(exception);
        curi.setFetchStatus(status);
        curi.getRecorder().close();
    }

    @Override
    public void start() {
        if (this.isRunning()) {
            return;
        }
        super.start();
        if (this.getCookieStore() != null) {
            this.getCookieStore().start();
        }
    }

    @Override
    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        super.stop();
        if (this.getCookieStore() != null) {
            AbstractCookieStore r = this.getCookieStore();
            if (r.getCookiesSaveFile() != null) {
                r.saveCookies(r.getCookiesSaveFile().getFile().getAbsolutePath());
            }
            this.getCookieStore().stop();
            this.setCookieStore(null);
        }
    }

    protected static String getServerKey(CrawlURI uri) {
        try {
            return CrawlServer.getServerKey(uri.getUURI());
        }
        catch (URIException e) {
            logger.log(Level.SEVERE, e.toString() + ": " + uri, e);
            return null;
        }
    }

    static {
        RegistryBuilder b = RegistryBuilder.create();
        b.register("Basic", (Object)new BasicSchemeFactory());
        b.register("Digest", (Object)new DigestSchemeFactory());
        AUTH_SCHEME_REGISTRY = b.build();
    }
}

