/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.fetcher;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.AbstractExecutionAwareRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.MessageConstraints;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.HttpConnectionFactory;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.ContentLengthStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.DefaultBHttpClientConnection;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.DefaultHttpResponseParserFactory;
import org.apache.http.impl.conn.ManagedHttpClientConnectionFactory;
import org.apache.http.impl.io.DefaultHttpRequestWriterFactory;
import org.apache.http.io.HttpMessageParserFactory;
import org.apache.http.io.HttpMessageWriterFactory;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HTTP;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.Args;
import org.archive.modules.CrawlURI;
import org.archive.modules.Processor;
import org.archive.modules.credential.Credential;
import org.archive.modules.credential.HtmlFormCredential;
import org.archive.modules.credential.HttpAuthenticationCredential;
import org.archive.modules.extractor.LinkContext;
import org.archive.modules.fetcher.BasicExecutionAwareEntityEnclosingRequest;
import org.archive.modules.fetcher.BasicExecutionAwareRequest;
import org.archive.modules.fetcher.FetchHTTP;
import org.archive.modules.fetcher.SocksSSLSocketFactory;
import org.archive.modules.fetcher.SocksSocketFactory;
import org.archive.modules.forms.HTMLForm;
import org.archive.modules.net.CrawlHost;
import org.archive.modules.net.CrawlServer;
import org.archive.modules.net.ServerCache;
import org.archive.util.Recorder;

public class FetchHTTPRequest {
    private boolean disableSNI = false;
    private static final Logger logger = Logger.getLogger(FetchHTTPRequest.class.getName());
    protected FetchHTTP fetcher;
    protected CrawlURI curi;
    protected HttpClientBuilder httpClientBuilder;
    protected RequestConfig.Builder requestConfigBuilder;
    protected HttpClientContext httpClientContext;
    protected AbstractExecutionAwareRequest request;
    protected HttpHost targetHost;
    protected boolean addedCredentials;
    protected HttpHost proxyHost;
    protected String socksProxyHost;
    protected Integer socksProxyPort;
    protected boolean useSocksProxy;
    protected HttpClientConnectionManager connMan;
    protected static final HttpRoutePlanner ROUTE_PLANNER = new HttpRoutePlanner(){

        public HttpRoute determineRoute(HttpHost host, HttpRequest request, HttpContext context) throws HttpException {
            Args.notNull((Object)host, (String)"Target host");
            Args.notNull((Object)request, (String)"Request");
            HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
            RequestConfig config = clientContext.getRequestConfig();
            InetAddress local = config.getLocalAddress();
            HttpHost proxy = config.getProxy();
            HttpHost target = host.getPort() > 0 && (host.getSchemeName().equalsIgnoreCase("http") && host.getPort() == 80 || host.getSchemeName().equalsIgnoreCase("https") && host.getPort() == 443) ? new HttpHost(host.getHostName(), -1, host.getSchemeName()) : host;
            boolean secure = target.getSchemeName().equalsIgnoreCase("https");
            if (proxy == null) {
                return new HttpRoute(target, local, secure);
            }
            return new HttpRoute(target, local, proxy, secure);
        }
    };

    public boolean isDisableSNI() {
        return this.disableSNI;
    }

    public void setDisableSNI(boolean disableSNI) {
        this.disableSNI = disableSNI;
    }

    public FetchHTTPRequest(FetchHTTP fetcher, CrawlURI curi) throws URIException {
        String requestLineUri;
        this.fetcher = fetcher;
        this.curi = curi;
        this.targetHost = new HttpHost(curi.getUURI().getHost(), curi.getUURI().getPort(), curi.getUURI().getScheme());
        this.httpClientContext = new HttpClientContext();
        this.requestConfigBuilder = RequestConfig.custom();
        ProtocolVersion httpVersion = fetcher.getConfiguredHttpVersion();
        this.socksProxyHost = (String)fetcher.getAttributeEither(curi, "socksProxyHost");
        this.socksProxyPort = (Integer)fetcher.getAttributeEither(curi, "socksProxyPort");
        this.useSocksProxy = false;
        if (StringUtils.isNotEmpty((String)this.socksProxyHost) && this.socksProxyPort != null) {
            InetSocketAddress socksAddress = new InetSocketAddress(this.socksProxyHost, (int)this.socksProxyPort);
            this.httpClientContext.setAttribute("socks.address", (Object)socksAddress);
            this.useSocksProxy = true;
        }
        String proxyHostname = (String)fetcher.getAttributeEither(curi, "httpProxyHost");
        Integer proxyPort = (Integer)fetcher.getAttributeEither(curi, "httpProxyPort");
        if (!(StringUtils.isNotEmpty((String)proxyHostname) && proxyPort != null || this.useSocksProxy)) {
            String sysPropertyPrefix = "https".equalsIgnoreCase(curi.getUURI().getScheme()) ? "https" : "http";
            proxyHostname = System.getProperty(sysPropertyPrefix + ".proxyHost");
            proxyPort = Integer.getInteger(sysPropertyPrefix + ".proxyPort");
        }
        if (StringUtils.isNotEmpty((String)proxyHostname) && proxyPort != null && !this.useSocksProxy) {
            this.proxyHost = new HttpHost(proxyHostname, proxyPort.intValue());
            this.requestConfigBuilder.setProxy(this.proxyHost);
            requestLineUri = "https".equalsIgnoreCase(curi.getUURI().getScheme()) ? curi.getUURI().getEscapedPathQuery() : curi.getUURI().toString();
        } else {
            requestLineUri = curi.getUURI().getEscapedPathQuery();
        }
        if (curi.getFetchType() == CrawlURI.FetchType.HTTP_POST) {
            BasicExecutionAwareEntityEnclosingRequest postRequest = new BasicExecutionAwareEntityEnclosingRequest("POST", requestLineUri, httpVersion);
            this.request = postRequest;
            if (curi.containsDataKey("submit-data")) {
                HttpEntity entity = this.buildPostRequestEntity(curi);
                postRequest.setEntity(entity);
            }
        } else {
            this.request = new BasicExecutionAwareRequest("GET", requestLineUri, httpVersion);
            curi.setFetchType(CrawlURI.FetchType.HTTP_GET);
        }
        if (this.proxyHost != null) {
            this.request.addHeader("Proxy-Connection", "close");
        }
        this.initHttpClientBuilder();
        this.configureHttpClientBuilder();
        this.configureRequestHeaders();
        this.configureRequest();
        this.addedCredentials = this.populateTargetCredential();
        this.populateHttpProxyCredential();
    }

    public static String escapeForMultipart(String str) {
        int codepoint;
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < str.length(); i += Character.charCount(codepoint)) {
            codepoint = str.codePointAt(i);
            if (codepoint <= 127) {
                buf.appendCodePoint(codepoint);
                continue;
            }
            buf.append("&#" + codepoint + ";");
        }
        return buf.toString();
    }

    protected HttpEntity buildPostRequestEntity(CrawlURI curi) {
        String enctype = (String)curi.getData().get("submit-enctype");
        if (enctype == null) {
            enctype = ContentType.APPLICATION_FORM_URLENCODED.getMimeType();
        }
        List submitData = (List)curi.getData().get("submit-data");
        if (enctype.equals(ContentType.APPLICATION_FORM_URLENCODED.getMimeType())) {
            LinkedList<BasicNameValuePair> nvps = new LinkedList<BasicNameValuePair>();
            for (HTMLForm.NameValue nv : submitData) {
                nvps.add(new BasicNameValuePair(nv.name, nv.value));
            }
            try {
                return new UrlEncodedFormEntity(nvps, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
        if (enctype.equals(ContentType.MULTIPART_FORM_DATA.getMimeType())) {
            MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
            entityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            for (HTMLForm.NameValue nv : submitData) {
                entityBuilder.addTextBody(FetchHTTPRequest.escapeForMultipart(nv.name), FetchHTTPRequest.escapeForMultipart(nv.value));
            }
            return entityBuilder.build();
        }
        throw new IllegalStateException("unsupported form submission enctype='" + enctype + "'");
    }

    protected void configureRequestHeaders() {
        String via;
        String from;
        if (this.fetcher.getAcceptCompression()) {
            this.request.addHeader("Accept-Encoding", "gzip,deflate");
        }
        if (StringUtils.isNotBlank((String)(from = this.fetcher.getUserAgentProvider().getFrom()))) {
            this.request.setHeader("From", from);
        }
        if (this.fetcher.getMaxLengthBytes() > 0L && this.fetcher.getSendRange()) {
            String rangeEnd = Long.toString(this.fetcher.getMaxLengthBytes() - 1L);
            this.request.setHeader("Range", "bytes=0-" + rangeEnd);
        }
        if (this.fetcher.getSendConnectionClose()) {
            this.request.setHeader("Connection", "Close");
        }
        if (!(!this.fetcher.getSendReferer() || LinkContext.PREREQ_MISC.equals(this.curi.getViaContext()) || StringUtils.isEmpty((String)(via = Processor.flattenVia(this.curi))) || this.curi.getVia().getScheme().equals("https") && this.curi.getUURI().getScheme().equals("http"))) {
            this.request.setHeader("Referer", via);
        }
        if (!this.curi.isPrerequisite()) {
            this.maybeAddConditionalGetHeader(this.fetcher.getSendIfModifiedSince(), "last-modified", "If-Modified-Since");
            this.maybeAddConditionalGetHeader(this.fetcher.getSendIfNoneMatch(), "etag", "If-None-Match");
        }
        for (String headerString : this.fetcher.getAcceptHeaders()) {
            String[] nameValue = headerString.split(": +");
            if (nameValue.length == 2) {
                this.request.addHeader(nameValue[0], nameValue[1]);
                continue;
            }
            logger.warning("Invalid accept header: " + headerString);
        }
        if (this.curi.getViaContext() != null && "a[data-remote='true']/@href".equals(this.curi.getViaContext().toString())) {
            this.request.addHeader("X-Requested-With", "XMLHttpRequest");
        }
        this.httpClientBuilder.addInterceptorLast(new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                Map uriCustomHeaders = (Map)FetchHTTPRequest.this.curi.getData().get("customHttpRequestHeaders");
                if (uriCustomHeaders != null) {
                    for (Map.Entry h : uriCustomHeaders.entrySet()) {
                        request.setHeader((String)h.getKey(), (String)h.getValue());
                    }
                }
            }
        });
    }

    protected void maybeAddConditionalGetHeader(boolean conditional, String sourceHeader, String targetHeader) {
        if (conditional) {
            try {
                HashMap<String, Object>[] history = this.curi.getFetchHistory();
                int previousStatus = (Integer)history[0].get("status");
                if (previousStatus <= 0) {
                    return;
                }
                String previousValue = (String)history[0].get(sourceHeader);
                if (previousValue != null) {
                    this.request.setHeader(targetHeader, previousValue);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    protected void configureRequest() {
        if (this.fetcher.getIgnoreCookies()) {
            this.requestConfigBuilder.setCookieSpec("ignoreCookies");
        } else {
            this.requestConfigBuilder.setCookieSpec("standard");
        }
        this.requestConfigBuilder.setConnectionRequestTimeout(this.fetcher.getSoTimeoutMs());
        this.requestConfigBuilder.setConnectTimeout(this.fetcher.getSoTimeoutMs());
        this.requestConfigBuilder.setSocketTimeout(this.fetcher.getSoTimeoutMs());
        String addressString = (String)this.fetcher.getAttributeEither(this.curi, "httpBindAddress");
        if (StringUtils.isNotEmpty((String)addressString)) {
            try {
                InetAddress localAddress = InetAddress.getByName(addressString);
                this.requestConfigBuilder.setLocalAddress(localAddress);
            }
            catch (UnknownHostException e) {
                throw new RuntimeException("failed to resolve configured http bind address " + addressString, e);
            }
        }
    }

    protected boolean populateTargetCredential() {
        String serverKey;
        try {
            serverKey = CrawlServer.getServerKey(this.curi.getUURI());
        }
        catch (URIException e) {
            return false;
        }
        CrawlServer server = this.fetcher.getServerCache().getServerFor(serverKey);
        if (server.hasCredentials()) {
            for (Credential c : server.getCredentials()) {
                if (!c.isEveryTime()) continue;
                if (c instanceof HttpAuthenticationCredential) {
                    HttpAuthenticationCredential cred = (HttpAuthenticationCredential)c;
                    AuthScheme authScheme = this.fetcher.chooseAuthScheme(server.getHttpAuthChallenges(), "WWW-Authenticate");
                    this.populateHttpCredential(this.targetHost, authScheme, cred.getLogin(), cred.getPassword());
                    continue;
                }
                this.populateHtmlFormCredential((HtmlFormCredential)c);
            }
        }
        boolean result = false;
        for (Credential c : this.curi.getCredentials()) {
            if (c instanceof HttpAuthenticationCredential) {
                HttpAuthenticationCredential cred = (HttpAuthenticationCredential)c;
                AuthScheme authScheme = this.fetcher.chooseAuthScheme(this.curi.getHttpAuthChallenges(), "WWW-Authenticate");
                this.populateHttpCredential(this.targetHost, authScheme, cred.getLogin(), cred.getPassword());
                result = true;
                continue;
            }
            result = this.populateHtmlFormCredential((HtmlFormCredential)c);
        }
        return result;
    }

    protected void populateHttpProxyCredential() {
        String user = (String)this.fetcher.getAttributeEither(this.curi, "httpProxyUser");
        String password = (String)this.fetcher.getAttributeEither(this.curi, "httpProxyPassword");
        Map challenges = (Map)this.fetcher.getKeyedProperties().get("proxyAuthChallenges");
        if (this.proxyHost != null && challenges != null && StringUtils.isNotEmpty((String)user)) {
            AuthScheme authScheme = this.fetcher.chooseAuthScheme(challenges, "Proxy-Authenticate");
            this.populateHttpCredential(this.proxyHost, authScheme, user, password);
        }
    }

    protected boolean populateHtmlFormCredential(HtmlFormCredential cred) {
        if (cred.getFormItems() == null || cred.getFormItems().size() <= 0) {
            logger.severe("No form items for " + this.curi);
            return false;
        }
        ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
        for (Map.Entry<String, String> n : cred.getFormItems().entrySet()) {
            formParams.add(new BasicNameValuePair(n.getKey(), n.getValue()));
        }
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(formParams, HTTP.DEF_CONTENT_CHARSET);
        HttpEntityEnclosingRequest entityEnclosingRequest = (HttpEntityEnclosingRequest)this.request;
        entityEnclosingRequest.setEntity((HttpEntity)entity);
        return true;
    }

    protected void populateHttpCredential(HttpHost host, AuthScheme authScheme, String user, String password) {
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(user, password);
        AuthCache authCache = this.httpClientContext.getAuthCache();
        if (authCache == null) {
            authCache = new BasicAuthCache();
            this.httpClientContext.setAuthCache(authCache);
        }
        if (!(authScheme instanceof DigestScheme)) {
            authCache.put(host, authScheme);
        }
        if (this.httpClientContext.getCredentialsProvider() == null) {
            this.httpClientContext.setCredentialsProvider((CredentialsProvider)new BasicCredentialsProvider());
        }
        this.httpClientContext.getCredentialsProvider().setCredentials(new AuthScope(host), (Credentials)credentials);
    }

    protected void configureHttpClientBuilder() throws URIException {
        String userAgent = this.curi.getUserAgent();
        if (userAgent == null) {
            userAgent = this.fetcher.getUserAgentProvider().getUserAgent();
        }
        this.httpClientBuilder.setUserAgent(userAgent);
        CookieStore cookieStore = this.fetcher.getCookieStore().cookieStoreFor(this.curi);
        this.httpClientBuilder.setDefaultCookieStore(cookieStore);
        this.connMan = this.buildConnectionManager();
        this.httpClientBuilder.setConnectionManager(this.connMan);
    }

    protected HttpClientConnectionManager buildConnectionManager() {
        Registry socketFactoryRegistry = this.useSocksProxy ? RegistryBuilder.create().register("http", (Object)new SocksSocketFactory()).register("https", (Object)new SocksSSLSocketFactory(SSLContexts.createSystemDefault())).build() : RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(this.fetcher.sslContext(), (X509HostnameVerifier)new AllowAllHostnameVerifier()){

            public Socket createLayeredSocket(Socket socket, String target, int port, HttpContext context) throws IOException {
                return super.createLayeredSocket(socket, FetchHTTPRequest.this.isDisableSNI() ? "" : target, port, context);
            }
        }).build();
        ServerCacheResolver dnsResolver = new ServerCacheResolver(this.fetcher.getServerCache());
        ManagedHttpClientConnectionFactory connFactory = new ManagedHttpClientConnectionFactory(){
            private static final int DEFAULT_BUFSIZE = 8192;

            public ManagedHttpClientConnection create(HttpRoute route, ConnectionConfig config) {
                CodingErrorAction unmappableInputAction;
                ConnectionConfig cconfig = config != null ? config : ConnectionConfig.DEFAULT;
                CharsetDecoder chardecoder = null;
                CharsetEncoder charencoder = null;
                Charset charset = cconfig.getCharset();
                CodingErrorAction malformedInputAction = cconfig.getMalformedInputAction() != null ? cconfig.getMalformedInputAction() : CodingErrorAction.REPORT;
                CodingErrorAction codingErrorAction = unmappableInputAction = cconfig.getUnmappableInputAction() != null ? cconfig.getUnmappableInputAction() : CodingErrorAction.REPORT;
                if (charset != null) {
                    chardecoder = charset.newDecoder();
                    chardecoder.onMalformedInput(malformedInputAction);
                    chardecoder.onUnmappableCharacter(unmappableInputAction);
                    charencoder = charset.newEncoder();
                    charencoder.onMalformedInput(malformedInputAction);
                    charencoder.onUnmappableCharacter(unmappableInputAction);
                }
                return new RecordingHttpClientConnection(8192, 8192, chardecoder, charencoder, cconfig.getMessageConstraints(), null, null, (HttpMessageWriterFactory<HttpRequest>)DefaultHttpRequestWriterFactory.INSTANCE, (HttpMessageParserFactory<HttpResponse>)DefaultHttpResponseParserFactory.INSTANCE, FetchHTTPRequest.this.proxyHost, FetchHTTPRequest.this.curi);
            }
        };
        BasicHttpClientConnectionManager connMan = new BasicHttpClientConnectionManager((Lookup)socketFactoryRegistry, (HttpConnectionFactory)connFactory, null, (DnsResolver)dnsResolver);
        SocketConfig.Builder socketConfigBuilder = SocketConfig.custom();
        socketConfigBuilder.setSoTimeout(this.fetcher.getSoTimeoutMs());
        connMan.setSocketConfig(socketConfigBuilder.build());
        return connMan;
    }

    protected void initHttpClientBuilder() {
        this.httpClientBuilder = HttpClientBuilder.create();
        this.httpClientBuilder.setDefaultAuthSchemeRegistry(FetchHTTP.AUTH_SCHEME_REGISTRY);
        this.httpClientBuilder.disableContentCompression();
        this.httpClientBuilder.disableRedirectHandling();
        this.httpClientBuilder.setRoutePlanner(ROUTE_PLANNER);
    }

    public HttpResponse execute() throws ClientProtocolException, IOException {
        CloseableHttpClient httpClient = this.httpClientBuilder.build();
        RequestConfig requestConfig = this.requestConfigBuilder.build();
        this.httpClientContext.setRequestConfig(requestConfig);
        return httpClient.execute(this.targetHost, (HttpRequest)this.request, (HttpContext)this.httpClientContext);
    }

    protected static class RecordingHttpClientConnection
    extends DefaultBHttpClientConnection
    implements ManagedHttpClientConnection {
        private static final AtomicLong COUNTER = new AtomicLong();
        private String id = "recording-http-connection-" + Long.toString(COUNTER.getAndIncrement());
        private final CrawlURI curi;
        private final boolean isProxyConnect;
        private boolean shouldWrapInput = true;
        private boolean shouldWrapOutput = true;

        public RecordingHttpClientConnection(int buffersize, int fragmentSizeHint, CharsetDecoder chardecoder, CharsetEncoder charencoder, MessageConstraints constraints, ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, HttpMessageWriterFactory<HttpRequest> requestWriterFactory, HttpMessageParserFactory<HttpResponse> responseParserFactory, HttpHost proxy, CrawlURI curi) {
            super(buffersize, fragmentSizeHint, chardecoder, charencoder, constraints, incomingContentStrategy, outgoingContentStrategy, requestWriterFactory, responseParserFactory);
            this.curi = curi;
            boolean bl = this.isProxyConnect = proxy != null && "https".equalsIgnoreCase(curi.getBaseURI().getScheme());
            if (this.isProxyConnect) {
                this.shouldWrapOutput = false;
                this.shouldWrapInput = false;
            }
        }

        protected InputStream getSocketInputStream(Socket socket) throws IOException {
            this.curi.setServerIP(socket.getInetAddress().getHostAddress());
            Recorder recorder = Recorder.getHttpRecorder();
            if (this.shouldWrapInput && recorder != null) {
                return recorder.inputWrap(super.getSocketInputStream(socket));
            }
            if (this.isProxyConnect) {
                this.shouldWrapInput = true;
            }
            return super.getSocketInputStream(socket);
        }

        protected OutputStream getSocketOutputStream(Socket socket) throws IOException {
            Recorder recorder = Recorder.getHttpRecorder();
            if (this.shouldWrapOutput && recorder != null) {
                return recorder.outputWrap(super.getSocketOutputStream(socket));
            }
            if (this.isProxyConnect) {
                this.shouldWrapOutput = true;
            }
            return super.getSocketOutputStream(socket);
        }

        public void close() throws IOException {
            super.close();
            Recorder recorder = Recorder.getHttpRecorder();
            if (recorder != null) {
                recorder.close();
                recorder.closeRecorders();
            }
        }

        public String getId() {
            return this.id;
        }

        public SSLSession getSSLSession() {
            Socket socket = super.getSocket();
            if (socket instanceof SSLSocket) {
                return ((SSLSocket)socket).getSession();
            }
            return null;
        }

        public Socket getSocket() {
            return super.getSocket();
        }
    }

    protected static class ServerCacheResolver
    implements DnsResolver {
        private static Logger logger = Logger.getLogger(DnsResolver.class.getName());
        protected ServerCache serverCache;

        public ServerCacheResolver(ServerCache serverCache) {
            this.serverCache = serverCache;
        }

        public InetAddress[] resolve(String host) throws UnknownHostException {
            InetAddress ip;
            CrawlHost crawlHost = this.serverCache.getHostFor(host);
            if (crawlHost != null && (ip = crawlHost.getIP()) != null) {
                return new InetAddress[]{ip};
            }
            logger.info("host \"" + host + "\" is not in serverCache, allowing java to resolve it");
            return new InetAddress[]{InetAddress.getByName(host)};
        }
    }
}

