/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.fetcher;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.URIException;
import org.archive.io.RecordingInputStream;
import org.archive.io.ReplayCharSequence;
import org.archive.modules.CrawlURI;
import org.archive.modules.Processor;
import org.archive.modules.extractor.Hop;
import org.archive.modules.extractor.LinkContext;
import org.archive.net.ClientSFTP;
import org.archive.net.UURI;
import org.archive.net.UURIFactory;
import org.archive.util.Recorder;

public class FetchSFTP
extends Processor {
    private static Logger logger = Logger.getLogger(FetchSFTP.class.getName());
    private static Pattern DIR = Pattern.compile("(.+)$", 8);
    protected String digestAlgorithm;

    public String getUsername() {
        return (String)this.kp.get("username");
    }

    public void setUsername(String username) {
        this.kp.put((Object)"username", (Object)username);
    }

    public String getPassword() {
        return (String)this.kp.get("password");
    }

    public void setPassword(String pw) {
        this.kp.put((Object)"password", (Object)pw);
    }

    public boolean getExtractFromDirs() {
        return (Boolean)this.kp.get("extractFromDirs");
    }

    public void setExtractFromDirs(boolean extractFromDirs) {
        this.kp.put((Object)"extractFromDirs", (Object)extractFromDirs);
    }

    public boolean getExtractParent() {
        return (Boolean)this.kp.get("extractParent");
    }

    public void setExtractParent(boolean extractParent) {
        this.kp.put((Object)"extractParent", (Object)extractParent);
    }

    public boolean getDigestContent() {
        return (Boolean)this.kp.get("digestContent");
    }

    public void setDigestContent(boolean digest) {
        this.kp.put((Object)"digestContent", (Object)digest);
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(String digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    public long getMaxLengthBytes() {
        return (Long)this.kp.get("maxLengthBytes");
    }

    public void setMaxLengthBytes(long timeout) {
        this.kp.put((Object)"maxLengthBytes", (Object)timeout);
    }

    public int getMaxFetchKBSec() {
        return (Integer)this.kp.get("maxFetchKBSec");
    }

    public void setMaxFetchKBSec(int rate) {
        this.kp.put((Object)"maxFetchKBSec", (Object)rate);
    }

    public int getTimeoutSeconds() {
        return (Integer)this.kp.get("timeoutSeconds");
    }

    public void setTimeoutSeconds(int timeout) {
        this.kp.put((Object)"timeoutSeconds", (Object)timeout);
    }

    public int getSoTimeoutMs() {
        return (Integer)this.kp.get("soTimeoutMs");
    }

    public void setSoTimeoutMs(int timeout) {
        this.kp.put((Object)"soTimeoutMs", (Object)timeout);
    }

    public FetchSFTP() {
        this.setUsername("anonymous");
        this.setPassword("password");
        this.setExtractFromDirs(true);
        this.setExtractParent(true);
        this.setDigestContent(true);
        this.digestAlgorithm = "sha1";
        this.setMaxLengthBytes(0L);
        this.setMaxFetchKBSec(0);
        this.setTimeoutSeconds(1200);
        this.setSoTimeoutMs(20000);
    }

    @Override
    protected boolean shouldProcess(CrawlURI curi) {
        return curi.getUURI().getScheme().equals("sftp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void innerProcess(CrawlURI curi) throws InterruptedException {
        curi.setFetchBeginTime(System.currentTimeMillis());
        ClientSFTP client = new ClientSFTP();
        Recorder recorder = curi.getRecorder();
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("attempting to fetch sftp uri: " + curi);
            }
            this.fetch(curi, client, recorder);
        }
        catch (IOException e) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info(curi + ": " + e);
            }
            curi.getNonFatalFailures().add(e);
            curi.setFetchStatus(-2);
        }
        finally {
            FetchSFTP.disconnect(client);
            curi.setFetchCompletedTime(System.currentTimeMillis());
            curi.getData().put("ftp-control-conversation", client.getControlConversation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetch(CrawlURI curi, ClientSFTP client, Recorder recorder) throws IOException, InterruptedException {
        UURI uuri = curi.getUURI();
        int port = uuri.getPort();
        if (port == -1) {
            port = 22;
        }
        String[] arrayOfString = this.getAuth(curi);
        client.connect(arrayOfString[0], uuri.getHost(), port, arrayOfString[1]);
        ChannelSftp channelSftp = null;
        try {
            channelSftp = client.openSFTPChannel();
        }
        catch (JSchException jSchException) {
            jSchException.printStackTrace();
            curi.getData().put("runtime-exception", (Object)jSchException);
        }
        boolean isDirectory = false;
        try {
            client.cd(uuri.getPath());
            isDirectory = client.isDirectory(uuri.getPath());
        }
        catch (SftpException sftpException) {
            try {
                client.cd("/");
            }
            catch (Exception exception) {
                logger.severe("cannot cd /");
                curi.getData().put("runtime-exception", (Object)sftpException);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            curi.getData().put("runtime-exception", exception);
        }
        if (isDirectory) {
            curi.getAnnotations().add("sftpDirectoryList");
        }
        if (channelSftp != null) {
            boolean digestContent = this.getDigestContent();
            String algorithm = null;
            if (digestContent) {
                algorithm = this.getDigestAlgorithm();
                recorder.getRecordedInput().setDigest(algorithm);
                recorder.getRecordedInput().startDigest();
            } else {
                recorder.getRecordedInput().setDigest((MessageDigest)null);
            }
            try {
                if (isDirectory) {
                    this.saveDirectoryToRecorder(curi, channelSftp, recorder);
                    curi.setFetchStatus(226);
                    curi.getData().put("ftp-fetch-status", "226 Directory send OK.");
                } else {
                    this.saveFileToRecorder(curi, channelSftp, recorder);
                    curi.setFetchStatus(226);
                    curi.getData().put("ftp-fetch-status", "226 File send OK.");
                }
            }
            catch (SftpException sftpException) {
                logger.severe("error while getting " + curi + " :" + (Object)((Object)sftpException));
                curi.setFetchStatus(-3);
                curi.getData().put("ftp-fetch-status", "SFTP error.");
            }
            finally {
                recorder.close();
                client.disconnect();
                curi.setContentSize(recorder.getRecordedInput().getSize());
                if (isDirectory) {
                    curi.setContentType("text/plain");
                } else {
                    curi.setContentType("application/octet-stream");
                }
                if (logger.isLoggable(Level.INFO)) {
                    logger.fine("read " + recorder.getRecordedInput().getSize() + " bytes from sftp data socket");
                }
                if (digestContent) {
                    curi.setContentDigest(algorithm, recorder.getRecordedInput().getDigestValue());
                }
            }
            curi.getData().put("runtime-exception", client.getControlConversation());
            if (isDirectory) {
                this.extract(curi, recorder);
            }
        }
        this.addParent(curi);
    }

    private void saveDirectoryToRecorder(CrawlURI paramCrawlURI, ChannelSftp paramChannelSftp, Recorder paramHttpRecorder) throws IOException, InterruptedException {
        try {
            Vector vector = paramChannelSftp.ls(paramCrawlURI.getUURI().getPath());
            StringBuilder stringBuilder = new StringBuilder();
            for (ChannelSftp.LsEntry lsEntry : vector) {
                stringBuilder.append(lsEntry.getFilename());
                stringBuilder.append('\n');
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stringBuilder.toString().getBytes());
            paramCrawlURI.setRecorder(paramHttpRecorder);
            paramHttpRecorder.inputWrap((InputStream)byteArrayInputStream);
            paramHttpRecorder.outputWrap(paramChannelSftp.getOutputStream());
            paramHttpRecorder.markContentBegin();
            long softMax = 0L;
            long hardMax = this.getMaxLengthBytes();
            long timeout = (long)this.getTimeoutSeconds() * 1000L;
            int maxRate = this.getMaxFetchKBSec();
            RecordingInputStream recordingInputStream = paramHttpRecorder.getRecordedInput();
            recordingInputStream.setLimits(hardMax, timeout, (long)maxRate);
            recordingInputStream.readFullyOrUntil(softMax);
        }
        catch (SftpException sftpException) {
            logger.severe("ls : " + paramCrawlURI.getUURI().getPath() + " not a path");
        }
    }

    private void saveFileToRecorder(CrawlURI paramCrawlURI, ChannelSftp paramChannelSftp, Recorder paramHttpRecorder) throws IOException, InterruptedException, SftpException {
        String str = new String(paramCrawlURI.getUURI().getPath());
        InputStream inputStream = paramChannelSftp.get(str);
        paramCrawlURI.setRecorder(paramHttpRecorder);
        paramHttpRecorder.inputWrap(inputStream);
        paramHttpRecorder.outputWrap(paramChannelSftp.getOutputStream());
        paramHttpRecorder.markContentBegin();
        long softMax = 0L;
        long hardMax = this.getMaxLengthBytes();
        long timeout = (long)this.getTimeoutSeconds() * 1000L;
        int maxRate = this.getMaxFetchKBSec();
        RecordingInputStream recordingInputStream = paramHttpRecorder.getRecordedInput();
        recordingInputStream.setLimits(hardMax, timeout, (long)maxRate);
        recordingInputStream.readFullyOrUntil(softMax);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extract(CrawlURI paramCrawlURI, Recorder paramHttpRecorder) {
        if (!this.getExtractFromDirs()) {
            return;
        }
        ReplayCharSequence replayCharSequence = null;
        try {
            replayCharSequence = paramHttpRecorder.getContentReplayCharSequence();
            this.extract(paramCrawlURI, replayCharSequence);
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "IO error during extraction.", iOException);
        }
        catch (RuntimeException runtimeException) {
            logger.log(Level.SEVERE, "IO error during extraction.", runtimeException);
        }
        finally {
            FetchSFTP.close(replayCharSequence);
        }
    }

    private void extract(CrawlURI paramCrawlURI, ReplayCharSequence paramReplayCharSequence) {
        Matcher matcher = DIR.matcher((CharSequence)paramReplayCharSequence);
        while (matcher.find()) {
            String str = matcher.group(1);
            this.addExtracted(paramCrawlURI, str);
        }
    }

    private void addExtracted(CrawlURI curi, String file) {
        String base;
        try {
            file = URLEncoder.encode(file, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Found " + file);
        }
        if ((base = curi.toString()).endsWith("/")) {
            base = base.substring(0, base.length() - 1);
        }
        try {
            UURI n = UURIFactory.getInstance((String)(base + "/" + file));
            CrawlURI link = curi.createCrawlURI(n, LinkContext.NAVLINK_MISC, Hop.NAVLINK);
            curi.getOutLinks().add(link);
        }
        catch (URIException e) {
            logger.log(Level.WARNING, "URI error during extraction.", e);
        }
    }

    private void addParent(CrawlURI curi) {
        if (!this.getExtractParent()) {
            return;
        }
        UURI uuri = curi.getUURI();
        try {
            if (uuri.getPath().equals("/")) {
                return;
            }
            String scheme = uuri.getScheme();
            String auth = uuri.getEscapedAuthority();
            String path = uuri.getEscapedCurrentHierPath();
            UURI parent = UURIFactory.getInstance((String)(scheme + "://" + auth + path));
            CrawlURI link = curi.createCrawlURI(parent, LinkContext.NAVLINK_MISC, Hop.NAVLINK);
            curi.getOutLinks().add(link);
        }
        catch (URIException uRIException) {
            logger.log(Level.WARNING, "URI error during extraction.", uRIException);
        }
    }

    private String[] getAuth(CrawlURI curi) {
        int p;
        String userinfo;
        String[] result = new String[2];
        UURI uuri = curi.getUURI();
        try {
            userinfo = uuri.getUserinfo();
        }
        catch (URIException e) {
            assert (false);
            logger.finest("getUserinfo raised URIException.");
            userinfo = null;
        }
        if (userinfo != null && (p = userinfo.indexOf(58)) > 0) {
            result[0] = userinfo.substring(0, p);
            result[1] = userinfo.substring(p + 1);
            return result;
        }
        result[0] = this.getUsername();
        result[1] = this.getPassword();
        return result;
    }

    private static void close(ReplayCharSequence paramReplayCharSequence) {
        if (paramReplayCharSequence == null) {
            return;
        }
        try {
            paramReplayCharSequence.close();
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "IO error closing ReplayCharSequence.", iOException);
        }
    }

    private static void disconnect(ClientSFTP paramClientSFTP) {
        if (paramClientSFTP.isConnected()) {
            paramClientSFTP.disconnect();
        }
    }
}

