/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.fetcher;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.archive.crawler.util.CrawledBytesHistotable;
import org.archive.modules.CrawlURI;
import org.archive.modules.fetcher.FetchStatusCodes;
import org.archive.util.ArchiveUtils;
import org.archive.util.ReportUtils;
import org.archive.util.Reporter;

public class FetchStats
extends CrawledBytesHistotable
implements Serializable,
FetchStatusCodes,
Reporter {
    private static final long serialVersionUID = 2L;
    public static final String TOTAL_SCHEDULED = "totalScheduled";
    public static final String FETCH_SUCCESSES = "fetchSuccesses";
    public static final String FETCH_FAILURES = "fetchFailures";
    public static final String FETCH_DISREGARDS = "fetchDisregards";
    public static final String FETCH_RESPONSES = "fetchResponses";
    public static final String ROBOTS_DENIALS = "robotsDenials";
    public static final String SUCCESS_BYTES = "successBytes";
    public static final String TOTAL_BYTES = "totalBytes";
    public static final String FETCH_NONRESPONSES = "fetchNonResponses";
    protected long lastSuccessTime;

    public FetchStats() {
    }

    public FetchStats(Comparator<String> comparator) {
        super(comparator);
    }

    public synchronized void tally(CrawlURI curi, Stage stage) {
        switch (stage) {
            case SCHEDULED: {
                this.tally(TOTAL_SCHEDULED, 1L);
                break;
            }
            case RETRIED: {
                if (curi.getFetchStatus() > 0) break;
                this.tally(FETCH_NONRESPONSES, 1L);
                break;
            }
            case SUCCEEDED: {
                this.tally(FETCH_SUCCESSES, 1L);
                this.tally(FETCH_RESPONSES, 1L);
                this.tally(TOTAL_BYTES, curi.getContentSize());
                this.tally(SUCCESS_BYTES, curi.getContentSize());
                this.lastSuccessTime = curi.getFetchCompletedTime();
                break;
            }
            case DISREGARDED: {
                this.tally(FETCH_DISREGARDS, 1L);
                if (curi.getFetchStatus() != -9998) break;
                this.tally(ROBOTS_DENIALS, 1L);
                break;
            }
            case FAILED: {
                if (curi.getFetchStatus() <= 0) {
                    this.tally(FETCH_NONRESPONSES, 1L);
                } else {
                    this.tally(FETCH_RESPONSES, 1L);
                    this.tally(TOTAL_BYTES, curi.getContentSize());
                }
                this.tally(FETCH_FAILURES, 1L);
                break;
            }
        }
        if (curi.getFetchStatus() > 0) {
            this.accumulate(curi);
        }
    }

    public long getFetchSuccesses() {
        return this.get(FETCH_SUCCESSES);
    }

    public long getFetchResponses() {
        return this.get(FETCH_RESPONSES);
    }

    public long getSuccessBytes() {
        return this.get(SUCCESS_BYTES);
    }

    @Override
    public long getTotalBytes() {
        return this.get(TOTAL_BYTES);
    }

    public long getFetchNonResponses() {
        return this.get(FETCH_NONRESPONSES);
    }

    public long getTotalScheduled() {
        return this.get(TOTAL_SCHEDULED);
    }

    public long getFetchDisregards() {
        return this.get(FETCH_DISREGARDS);
    }

    public long getRobotsDenials() {
        return this.get(ROBOTS_DENIALS);
    }

    public long getRemaining() {
        return this.get(TOTAL_SCHEDULED) - (this.get(FETCH_SUCCESSES) + this.get(FETCH_FAILURES) + this.get(FETCH_DISREGARDS));
    }

    public long getRecordedFinishes() {
        return this.get(FETCH_SUCCESSES) + this.get(FETCH_FAILURES);
    }

    public long getNovelBytes() {
        return this.get("novel");
    }

    public long getNovelUrls() {
        return this.get("novelCount");
    }

    public long getNotModifiedBytes() {
        return this.get("notModified");
    }

    public long getNotModifiedUrls() {
        return this.get("notModifiedCount");
    }

    public long getDupByHashBytes() {
        return this.get("dupByHash");
    }

    public long getDupByHashUrls() {
        return this.get("dupByHashCount");
    }

    public long getOtherDupBytes() {
        return this.get("otherDup");
    }

    public long getOtherDupUrls() {
        return this.get("otherDupCount");
    }

    public void reportTo(PrintWriter writer) {
        writer.println(this.shortReportLegend());
        this.shortReportLineTo(writer);
    }

    public String shortReportLegend() {
        return "totalScheduled fetchSuccesses fetchFailures fetchDisregards fetchResponses robotsDenials successBytes totalBytes fetchNonResponses lastSuccessTime";
    }

    public String shortReportLine() {
        return ReportUtils.shortReportLine((Reporter)this);
    }

    public void shortReportLineTo(PrintWriter writer) {
        writer.print(this.get(TOTAL_SCHEDULED));
        writer.print(" ");
        writer.print(this.get(FETCH_SUCCESSES));
        writer.print(" ");
        writer.print(this.get(FETCH_FAILURES));
        writer.print(" ");
        writer.print(this.get(FETCH_DISREGARDS));
        writer.print(" ");
        writer.print(this.get(FETCH_RESPONSES));
        writer.print(" ");
        writer.print(this.get(ROBOTS_DENIALS));
        writer.print(" ");
        writer.print(this.get(SUCCESS_BYTES));
        writer.print(" ");
        writer.print(this.get(TOTAL_BYTES));
        writer.print(" ");
        writer.print(this.get(FETCH_NONRESPONSES));
        writer.print(" ");
        writer.print(ArchiveUtils.getLog17Date((long)this.lastSuccessTime));
    }

    public Map<String, Object> shortReportMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>((Map<String, Object>)((Object)this));
        map.put("lastSuccessTime", this.lastSuccessTime);
        return map;
    }

    public long getLastSuccessTime() {
        return this.lastSuccessTime;
    }

    public static interface CollectsFetchStats {
        public void tally(CrawlURI var1, Stage var2);
    }

    public static interface HasFetchStats {
        public FetchStats getSubstats();
    }

    public static enum Stage {
        SCHEDULED,
        RELOCATED,
        RETRIED,
        SUCCEEDED,
        DISREGARDED,
        FAILED;

    }
}

