/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.fetcher;

import com.google.common.net.InternetDomainName;
import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.tuple.IntegerBinding;
import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.net.whois.WhoisClient;
import org.archive.bdb.BdbModule;
import org.archive.modules.CoreAttributeConstants;
import org.archive.modules.CrawlURI;
import org.archive.modules.ProcessResult;
import org.archive.modules.Processor;
import org.archive.modules.extractor.Extractor;
import org.archive.modules.extractor.Hop;
import org.archive.modules.extractor.LinkContext;
import org.archive.modules.fetcher.FetchStatusCodes;
import org.archive.modules.net.CrawlHost;
import org.archive.modules.net.ServerCache;
import org.archive.util.Recorder;
import org.archive.util.TextUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.Lifecycle;

public class FetchWhois
extends Processor
implements CoreAttributeConstants,
FetchStatusCodes,
Lifecycle {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(FetchWhois.class.getName());
    public static final String IP_ADDRESS_REGEX = "\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}";
    protected static final String DEFAULT_IP_WHOIS_SERVER = "whois.arin.net";
    protected static final String ULTRA_SUFFIX_WHOIS_SERVER = "whois.iana.org";
    protected static String WHOIS_SERVER_REGEX = "(?i)^\\s*(?:whois server|ReferralServer|whois)[^:]*:.*?([a-zA-Z0-9-]+\\.[a-zA-Z0-9.:-]+)/*$";
    private transient Database whoisDb;
    private transient StoredSortedMap<String, String> referralServers;
    private transient StoredSortedMap<String, Integer> urlProgress;
    protected BdbModule bdb;
    protected Map<String, String> specialQueryTemplates = new HashMap<String, String>();
    private boolean isRunning;
    protected ServerCache serverCache;

    public FetchWhois() {
        this.specialQueryTemplates.put("whois.verisign-grs.com", "domain %s");
        this.specialQueryTemplates.put(DEFAULT_IP_WHOIS_SERVER, "z + %s");
        this.specialQueryTemplates.put("whois.denic.de", "-T dn %s");
        this.setSoTimeoutMs(20000);
        this.isRunning = false;
    }

    @Autowired
    public void setBdbModule(BdbModule bdb) {
        this.bdb = bdb;
    }

    public void setSpecialQueryTemplates(Map<String, String> m) {
        this.specialQueryTemplates.clear();
        this.specialQueryTemplates.putAll(m);
    }

    public int getSoTimeoutMs() {
        return (Integer)this.kp.get("soTimeoutMs");
    }

    public void setSoTimeoutMs(int timeout) {
        this.kp.put((Object)"soTimeoutMs", (Object)timeout);
    }

    @Override
    public void start() {
        if (this.isRunning()) {
            return;
        }
        try {
            BdbModule.BdbConfig dbConfig = new BdbModule.BdbConfig();
            dbConfig.setTransactional(false);
            boolean isRecovery = this.recoveryCheckpoint != null;
            dbConfig.setAllowCreate(!isRecovery);
            this.whoisDb = this.bdb.openDatabase("whoisKnowledge", dbConfig, isRecovery);
            this.referralServers = new StoredSortedMap(this.whoisDb, (EntryBinding)new StringBinding(), (EntryBinding)new StringBinding(), true);
            this.urlProgress = new StoredSortedMap(this.whoisDb, (EntryBinding)new StringBinding(), (EntryBinding)new IntegerBinding(), true);
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
        this.isRunning = true;
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void stop() {
        this.isRunning = false;
        this.bdb = null;
    }

    @Override
    protected ProcessResult innerProcessResult(CrawlURI curi) throws InterruptedException {
        if (curi.getUURI().getScheme().equals("whois")) {
            curi.setFetchBeginTime(System.currentTimeMillis());
            String whoisServer = this.getWhoisServer(curi);
            String whoisQuery = this.getWhoisQuery(curi);
            if (whoisServer == null) {
                ProcessResult ret = this.deferOrFinishGeneric(curi, whoisQuery);
                return ret;
            }
            this.fetch(curi, whoisServer, whoisQuery);
            return ProcessResult.PROCEED;
        }
        this.addWhoisLinks(curi);
        return ProcessResult.PROCEED;
    }

    protected ProcessResult deferOrFinishGeneric(CrawlURI curi, String domainOrIp) {
        String tryThis = null;
        String ultraSuffix = domainOrIp.substring(domainOrIp.lastIndexOf(46) + 1).toLowerCase();
        if (this.referralServers.containsKey((Object)domainOrIp)) {
            tryThis = "whois://" + (String)this.referralServers.get((Object)domainOrIp) + '/' + domainOrIp;
        } else if (TextUtils.getMatcher((String)IP_ADDRESS_REGEX, (CharSequence)domainOrIp).matches()) {
            tryThis = this.makeWhoisUrl(DEFAULT_IP_WHOIS_SERVER, domainOrIp);
        } else if (this.referralServers.containsKey((Object)ultraSuffix)) {
            tryThis = this.makeWhoisUrl((String)this.referralServers.get((Object)ultraSuffix), domainOrIp);
        } else if (this.urlProgress.get((Object)this.makeWhoisUrl(ULTRA_SUFFIX_WHOIS_SERVER, ultraSuffix)) == null) {
            tryThis = this.makeWhoisUrl(ULTRA_SUFFIX_WHOIS_SERVER, ultraSuffix);
        } else {
            logger.warning("apparently no whois server for \"" + domainOrIp + "\"");
            curi.setFetchStatus(-62);
            return ProcessResult.PROCEED;
        }
        assert (tryThis != null);
        Integer progress = (Integer)this.urlProgress.get((Object)tryThis);
        if (tryThis == null || progress != null && progress.intValue() == UrlStatus.DONE.ordinal()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("finished with generic serverless whois uri " + curi);
            }
            curi.setFetchStatus(2002);
            return ProcessResult.PROCEED;
        }
        if (progress == null) {
            try {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(curi + " marking prerequisite " + tryThis + " and deferring");
                }
                CrawlURI caUri = curi.markPrerequisite(tryThis);
                caUri.setForceFetch(false);
                this.urlProgress.put((Object)tryThis, (Object)UrlStatus.IN_PROGRESS.ordinal());
            }
            catch (URIException e) {
                throw new RuntimeException(e);
            }
        } else {
            curi.incrementDeferrals();
            curi.setFetchStatus(-50);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(curi + ": prerequisite " + tryThis + " is in progress, deferring");
            }
        }
        return ProcessResult.FINISH;
    }

    protected String makeWhoisUrl(String server, String principal) {
        try {
            String template = this.specialQueryTemplates.get(server.toLowerCase());
            String query = template != null ? template.replaceAll("%s", principal) : principal;
            return "whois://" + server + "/" + URLEncoder.encode(query, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetch(CrawlURI curi, String whoisServer, String whoisQuery) {
        WhoisClient client = new WhoisClient();
        Recorder recorder = curi.getRecorder();
        try {
            client.setConnectTimeout(this.getSoTimeoutMs());
            client.setDefaultTimeout(this.getSoTimeoutMs());
            if (curi.getUURI().getPort() > 0) {
                client.connect(whoisServer, curi.getUURI().getPort());
            } else {
                client.connect(whoisServer);
            }
            client.setSoTimeout(this.getSoTimeoutMs());
            curi.setServerIP(client.getRemoteAddress().getHostAddress());
            recorder.inputWrap(client.getInputStream(whoisQuery));
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)recorder.getRecordedInput(), "ASCII"));
            String line = reader.readLine();
            while (line != null) {
                Matcher matcher = TextUtils.getMatcher((String)WHOIS_SERVER_REGEX, (CharSequence)line);
                if (matcher.find()) {
                    String key = whoisQuery.replaceFirst("(\\S+\\s+)+", "").toLowerCase();
                    this.referralServers.put((Object)key, (Object)matcher.group(1).toLowerCase());
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("added referral server " + matcher.group(1) + " to server list for " + key);
                    }
                }
                line = reader.readLine();
            }
            curi.setContentType("text/plain");
            curi.setFetchStatus(2001);
        }
        catch (IOException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("failed to connect to whois server for uri " + curi + ": " + e);
            }
            curi.getNonFatalFailures().add(e);
            curi.setFetchStatus(-2);
        }
        finally {
            recorder.close();
            curi.setContentSize(recorder.getRecordedInput().getSize());
            logger.fine(curi + ": " + recorder.getRecordedInput().getSize() + " bytes read");
            if (client != null && client.isConnected()) {
                try {
                    client.disconnect();
                }
                catch (IOException e) {
                    logger.fine("problem closing connection to whois server for uri " + curi + ": " + e);
                }
            }
            this.urlProgress.put((Object)curi.toString(), (Object)UrlStatus.DONE.ordinal());
        }
    }

    protected String getWhoisQuery(CrawlURI curi) {
        try {
            if (curi.getUURI().getAuthority() == null) {
                return curi.getUURI().getPathQuery();
            }
            return curi.getUURI().getPathQuery().substring(1);
        }
        catch (URIException e) {
            logger.log(Level.SEVERE, "Failed to get path/query from uri " + curi, e);
            return null;
        }
    }

    protected String getWhoisServer(CrawlURI curi) {
        String whoisServer = null;
        try {
            whoisServer = curi.getUURI().getHost();
            if (whoisServer != null && whoisServer.length() == 0) {
                whoisServer = null;
            }
        }
        catch (URIException e) {
            logger.warning("Failed to get host from uri " + curi + ": " + (Object)((Object)e));
            whoisServer = null;
        }
        return whoisServer;
    }

    @Override
    protected boolean shouldProcess(CrawlURI uri) {
        return true;
    }

    public ServerCache getServerCache() {
        return this.serverCache;
    }

    @Autowired
    public void setServerCache(ServerCache serverCache) {
        this.serverCache = serverCache;
    }

    protected void addWhoisLink(CrawlURI curi, String query) {
        String whoisUrl = "whois:" + query;
        try {
            Extractor.add(curi, Integer.MAX_VALUE, whoisUrl, LinkContext.INFERRED_MISC, Hop.INFERRED);
        }
        catch (URIException e) {
            logger.log(Level.WARNING, "problem with url " + whoisUrl, e);
        }
    }

    protected void addWhoisLinks(CrawlURI curi) throws InterruptedException {
        CrawlHost ch = this.serverCache.getHostFor(curi.getUURI());
        if (ch == null) {
            return;
        }
        if (ch.getIP() != null) {
            this.addWhoisLink(curi, ch.getIP().getHostAddress());
        }
        if (InternetDomainName.isValid((String)ch.getHostName())) {
            try {
                String topmostAssigned = InternetDomainName.from((String)ch.getHostName()).topPrivateDomain().toString();
                this.addWhoisLink(curi, topmostAssigned);
            }
            catch (IllegalStateException e) {
                logger.warning("problem resolving topmost assigned domain, will try whois lookup on the plain hostname " + ch.getHostName() + " - " + e);
                this.addWhoisLink(curi, ch.getHostName());
            }
        }
    }

    @Override
    protected void innerProcess(CrawlURI uri) throws InterruptedException {
        throw new RuntimeException("this method shouldn't be called - should use innerProcessResult()");
    }

    protected static enum UrlStatus {
        IN_PROGRESS,
        DONE;

    }
}

