/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.forms;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.lang.StringUtils;
import org.archive.checkpointing.Checkpointable;
import org.archive.modules.CrawlURI;
import org.archive.modules.Processor;
import org.archive.modules.extractor.Hop;
import org.archive.modules.extractor.LinkContext;
import org.archive.modules.extractor.UriErrorLoggerModule;
import org.archive.modules.forms.HTMLForm;
import org.archive.util.JSONUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;

public class FormLoginProcessor
extends Processor
implements Checkpointable {
    private static final long serialVersionUID = -1L;
    private static final Logger logger = Logger.getLogger(FormLoginProcessor.class.getName());
    protected LoadingCache<String, AtomicLong> eligibleFormsSeenCount = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, AtomicLong>(){

        public AtomicLong load(String arg0) {
            return new AtomicLong(0L);
        }
    });
    protected LoadingCache<String, AtomicLong> eligibleFormsAttemptsCount = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, AtomicLong>(){

        public AtomicLong load(String arg0) {
            return new AtomicLong(0L);
        }
    });
    protected transient UriErrorLoggerModule loggerModule;

    public String getApplicableSurtPrefix() {
        return (String)this.kp.get("applicableSurtPrefix");
    }

    public void setApplicableSurtPrefix(String applicableSurtPrefix) {
        this.kp.put((Object)"applicableSurtPrefix", (Object)applicableSurtPrefix);
    }

    public String getLoginUsername() {
        return (String)this.kp.get("loginUsername");
    }

    public void setLoginUsername(String loginUsername) {
        this.kp.put((Object)"loginUsername", (Object)loginUsername);
    }

    public String getLoginPassword() {
        return (String)this.kp.get("loginPassword");
    }

    public void setLoginPassword(String loginPassword) {
        this.kp.put((Object)"loginPassword", (Object)loginPassword);
    }

    public UriErrorLoggerModule getLoggerModule() {
        return this.loggerModule;
    }

    @Autowired
    public void setLoggerModule(UriErrorLoggerModule loggerModule) {
        this.loggerModule = loggerModule;
    }

    public FormLoginProcessor() {
        this.setApplicableSurtPrefix("");
        this.setLoginUsername("");
        this.setLoginPassword("");
    }

    @Override
    protected boolean shouldProcess(CrawlURI curi) {
        return StringUtils.isNotEmpty((String)this.getLoginUsername());
    }

    @Override
    protected void innerProcess(CrawlURI curi) {
        if (!curi.getUURI().getSurtForm().startsWith(this.getApplicableSurtPrefix())) {
            return;
        }
        String formProvince = this.getFormProvince(curi);
        curi.getDataList("warc-response-headers").add(this.warcHeaderFor(formProvince));
        if (curi.getDataList("html-form-objects").size() > 0) {
            for (Object formObject : curi.getDataList("html-form-objects")) {
                HTMLForm form = (HTMLForm)formObject;
                if (!form.seemsLoginForm()) continue;
                try {
                    ((AtomicLong)this.eligibleFormsSeenCount.get((Object)formProvince)).incrementAndGet();
                    if (((AtomicLong)this.eligibleFormsAttemptsCount.get((Object)formProvince)).get() < 1L) {
                        ((AtomicLong)this.eligibleFormsAttemptsCount.get((Object)formProvince)).incrementAndGet();
                        this.createFormSubmissionAttempt(curi, form, formProvince);
                    } else {
                        curi.getAnnotations().add("nosubmit:" + this.submitStatusFor(formProvince));
                    }
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
                return;
            }
        }
    }

    protected String getFormProvince(CrawlURI curi) {
        if (StringUtils.isNotBlank((String)this.getApplicableSurtPrefix())) {
            return this.getApplicableSurtPrefix();
        }
        try {
            return curi.getUURI().resolve("/").getSurtForm();
        }
        catch (URIException e) {
            logger.log(Level.WARNING, "error trimming to root", e);
            return curi.getClassKey();
        }
    }

    protected void createFormSubmissionAttempt(CrawlURI curi, HTMLForm templateForm, String formProvince) {
        LinkContext.SimpleLinkContext lc = new LinkContext.SimpleLinkContext("form/@action");
        try {
            String submitUrl = templateForm.getAction() == null ? curi.getURI() : templateForm.getAction();
            CrawlURI submitCuri = curi.createCrawlURI(submitUrl, (LinkContext)lc, Hop.SUBMIT);
            submitCuri.setFetchType(CrawlURI.FetchType.HTTP_POST);
            submitCuri.getData().put("submit-data", templateForm.formData(this.getLoginUsername(), this.getLoginPassword()));
            submitCuri.getData().put("submit-enctype", templateForm.getEnctype());
            submitCuri.setSchedulingDirective(1);
            submitCuri.setForceFetch(true);
            curi.getOutLinks().add(submitCuri);
            curi.getAnnotations().add("submit:" + templateForm.getAction());
        }
        catch (URIException ue) {
            this.loggerModule.logUriError(ue, curi.getUURI(), templateForm.getAction());
        }
    }

    protected String warcHeaderFor(String formProvince) {
        return "WARC-Simple-Form-Province-Status: " + this.submitStatusFor(formProvince);
    }

    protected String submitStatusFor(String formProvince) {
        try {
            return ((AtomicLong)this.eligibleFormsAttemptsCount.get((Object)formProvince)).get() + "," + ((AtomicLong)this.eligibleFormsSeenCount.get((Object)formProvince)).get() + "," + formProvince;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected JSONObject toCheckpointJson() throws JSONException {
        JSONObject json = super.toCheckpointJson();
        json.put("eligibleFormsAttemptsCount", (Map)this.eligibleFormsAttemptsCount.asMap());
        json.put("eligibleFormsSeenCount", (Map)this.eligibleFormsSeenCount.asMap());
        return json;
    }

    @Override
    protected void fromCheckpointJson(JSONObject json) throws JSONException {
        super.fromCheckpointJson(json);
        JSONUtils.putAllAtomicLongs((Map)this.eligibleFormsAttemptsCount.asMap(), (JSONObject)json.getJSONObject("eligibleFormsAttemptsCount"));
        JSONUtils.putAllAtomicLongs((Map)this.eligibleFormsSeenCount.asMap(), (JSONObject)json.getJSONObject("eligibleFormsSeenCount"));
    }
}

