/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.forms;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class HTMLForm {
    protected String method;
    protected String action;
    protected String enctype;
    protected List<FormInput> allInputs = new ArrayList<FormInput>();
    protected List<FormInput> candidateUsernameInputs = new ArrayList<FormInput>();
    protected List<FormInput> candidatePasswordInputs = new ArrayList<FormInput>();

    public void addField(String type, String name, String value, boolean checked) {
        FormInput input = new FormInput();
        input.type = type;
        if (this.isMultipleFormSubmitInputs(type)) {
            return;
        }
        if (input.type == null) {
            input.type = "text";
        }
        input.name = name;
        input.value = value;
        input.checked = checked;
        this.allInputs.add(input);
        if ("text".equalsIgnoreCase(input.type) || "email".equalsIgnoreCase(input.type)) {
            this.candidateUsernameInputs.add(input);
        } else if ("password".equalsIgnoreCase(type)) {
            this.candidatePasswordInputs.add(input);
        }
    }

    public boolean isMultipleFormSubmitInputs(String type) {
        if (type != null && !type.toLowerCase().equals("submit")) {
            return false;
        }
        for (FormInput input : this.allInputs) {
            if (!input.type.toLowerCase().equals("submit")) continue;
            return true;
        }
        return false;
    }

    public void addField(String type, String name, String value) {
        this.addField(type, name, value, false);
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getEnctype() {
        return this.enctype;
    }

    public void setEnctype(String enctype) {
        this.enctype = enctype;
    }

    public boolean seemsLoginForm() {
        return "post".equalsIgnoreCase(this.method) && this.candidatePasswordInputs.size() == 1 && this.presumedUsernameInput() != null;
    }

    protected FormInput presumedUsernameInput() {
        if (this.candidateUsernameInputs.size() < 1) {
            return null;
        }
        if (this.candidateUsernameInputs.size() == 1) {
            return this.candidateUsernameInputs.get(0);
        }
        FormInput choice = null;
        for (FormInput input : this.candidateUsernameInputs) {
            if (input.name == null || input.name.toLowerCase().indexOf("username") == -1) continue;
            if (choice == null) {
                choice = input;
                continue;
            }
            return null;
        }
        return choice;
    }

    public LinkedList<NameValue> formData(String username, String password) {
        LinkedList<NameValue> nameVals = new LinkedList<NameValue>();
        for (FormInput input : this.allInputs) {
            if (input == this.presumedUsernameInput()) {
                nameVals.add(new NameValue(input.name, username));
                continue;
            }
            if (input == this.candidatePasswordInputs.get(0)) {
                nameVals.add(new NameValue(input.name, password));
                continue;
            }
            if (("radio".equalsIgnoreCase(input.type) || "checkbox".equals(input.type)) && !input.checked) continue;
            nameVals.add(new NameValue(StringUtils.isEmpty((String)input.name) ? "" : input.name, StringUtils.isEmpty((String)input.value) ? "" : input.value));
        }
        return nameVals;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.method);
        sb.append(" ");
        sb.append(this.action);
        for (FormInput input : this.allInputs) {
            sb.append("\n  ");
            sb.append(input.type);
            sb.append(" ");
            sb.append(input.name);
            sb.append(" ");
            sb.append(input.value);
        }
        return sb.toString();
    }

    public String asAnnotation() {
        StringBuilder sb = new StringBuilder();
        sb.append("form:");
        sb.append(Character.toUpperCase(this.method.charAt(0)));
        for (FormInput input : this.allInputs) {
            sb.append(Character.toLowerCase(input.type.charAt(0)));
        }
        return sb.toString();
    }

    public static class NameValue
    implements Serializable {
        public String name;
        public String value;

        public NameValue(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    public class FormInput {
        public String type;
        public String name;
        public String value;
        public boolean checked = false;

        public String toString() {
            String str = "input[@type='" + this.type + "'][@name='" + this.name + "'][@value='" + this.value + "']";
            if (this.checked) {
                str = str + "[@checked]";
            }
            return str;
        }
    }
}

