/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.net;

import com.sleepycat.je.DatabaseException;
import java.io.IOException;
import org.archive.bdb.BdbModule;
import org.archive.checkpointing.Checkpoint;
import org.archive.checkpointing.Checkpointable;
import org.archive.modules.fetcher.DefaultServerCache;
import org.archive.modules.net.CrawlHost;
import org.archive.modules.net.CrawlServer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.Lifecycle;

public class BdbServerCache
extends DefaultServerCache
implements Lifecycle,
Checkpointable {
    private static final long serialVersionUID = 1L;
    protected BdbModule bdb;
    protected boolean isRunning = false;
    protected boolean isCheckpointRecovery = false;

    @Autowired
    public void setBdbModule(BdbModule bdb) {
        this.bdb = bdb;
    }

    public void start() {
        if (this.isRunning()) {
            return;
        }
        try {
            this.servers = this.bdb.getObjectCache("servers", this.isCheckpointRecovery, CrawlServer.class, CrawlServer.class);
            this.hosts = this.bdb.getObjectCache("hosts", this.isCheckpointRecovery, CrawlHost.class, CrawlHost.class);
        }
        catch (DatabaseException e) {
            throw new IllegalStateException(e);
        }
        this.isRunning = true;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void stop() {
        this.isRunning = false;
    }

    public void startCheckpoint(Checkpoint checkpointInProgress) {
    }

    public void doCheckpoint(Checkpoint checkpointInProgress) throws IOException {
    }

    public void finishCheckpoint(Checkpoint checkpointInProgress) {
    }

    @Autowired(required=false)
    public void setRecoveryCheckpoint(Checkpoint recoveryCheckpoint) {
        this.isCheckpointRecovery = true;
    }
}

