/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.net;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.bdb.AutoKryo;
import org.archive.modules.fetcher.FetchStats;
import org.archive.util.IdentityCacheable;
import org.archive.util.InetAddressUtil;
import org.archive.util.ObjectIdentityCache;

public class CrawlHost
implements Serializable,
FetchStats.HasFetchStats,
IdentityCacheable {
    private static final long serialVersionUID = -5494573967890942895L;
    private static final Logger logger = Logger.getLogger(CrawlHost.class.getName());
    public static final long IP_NEVER_EXPIRES = -1L;
    public static final long IP_NEVER_LOOKED_UP = -2L;
    private String hostname;
    private String countryCode;
    private InetAddress ip;
    private long ipFetched = -2L;
    protected FetchStats substats = new FetchStats();
    private long ipTTL = -2L;
    private long earliestNextURIEmitTime = 0L;
    private transient ObjectIdentityCache<?> cache;

    public CrawlHost(String hostname) {
        this(hostname, null);
    }

    public CrawlHost(String hostname, String countryCode) {
        this.hostname = hostname;
        this.countryCode = countryCode;
        InetAddress tmp = InetAddressUtil.getIPHostAddress((String)hostname);
        if (tmp != null) {
            this.setIP(tmp, -1L);
        }
    }

    public boolean hasBeenLookedUp() {
        return this.ipFetched != -2L;
    }

    public void setIP(InetAddress address, long ttl) {
        this.ip = address;
        this.ipFetched = System.currentTimeMillis();
        this.ipTTL = ttl;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.hostname + ": " + (address != null ? address.toString() : "null"));
        }
    }

    public InetAddress getIP() {
        return this.ip;
    }

    public long getIpFetched() {
        return this.ipFetched;
    }

    public long getIpTTL() {
        return this.ipTTL;
    }

    public String toString() {
        return "CrawlHost<" + this.hostname + "(ip:" + this.ip + ")>";
    }

    public int hashCode() {
        return this.hostname != null ? this.hostname.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CrawlHost other = (CrawlHost)obj;
        return this.hostname == other.hostname || this.hostname != null && this.hostname.equals(other.hostname);
    }

    public String getHostName() {
        return this.hostname;
    }

    public long getEarliestNextURIEmitTime() {
        return this.earliestNextURIEmitTime;
    }

    public void setEarliestNextURIEmitTime(long earliestNextURIEmitTime) {
        this.earliestNextURIEmitTime = earliestNextURIEmitTime;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    @Override
    public FetchStats getSubstats() {
        return this.substats;
    }

    public static void autoregisterTo(AutoKryo kryo) {
        kryo.register(CrawlHost.class);
        kryo.autoregister(FetchStats.class);
        kryo.register(Inet4Address.class, (Serializer)new Serializer<Inet4Address>(){

            public void write(Kryo kryo, Output output, Inet4Address inet4Address) {
                kryo.writeObject(output, (Object)inet4Address.getAddress());
            }

            public Inet4Address read(Kryo kryo, Input input, Class<? extends Inet4Address> aClass) {
                byte[] address = (byte[])kryo.readObject(input, byte[].class);
                try {
                    return (Inet4Address)InetAddress.getByAddress(address);
                }
                catch (UnknownHostException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        kryo.autoregister(byte[].class);
    }

    public String getKey() {
        return this.getHostName();
    }

    public void makeDirty() {
        this.cache.dirtyKey(this.getKey());
    }

    public void setIdentityCache(ObjectIdentityCache<?> cache) {
        this.cache = cache;
    }

    public String fixUpName() {
        if ("dns:".equals(this.getHostName()) || "whois:".equals(this.getHostName())) {
            return this.getHostName();
        }
        try {
            return URLEncoder.encode(this.getHostName(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

